/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retrofit;

import io.github.resilience4j.retrofit.RetrofitRetry;
import io.github.resilience4j.retry.Retry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Retrofit;

public final class RetryCallAdapter
extends CallAdapter.Factory {
    private final Retry retry;

    private RetryCallAdapter(Retry retry) {
        this.retry = retry;
    }

    public static RetryCallAdapter of(Retry retry) {
        return new RetryCallAdapter(retry);
    }

    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        final CallAdapter nextAdapter = retrofit.nextCallAdapter((CallAdapter.Factory)this, returnType, annotations);
        return new CallAdapter<Object, Object>(){

            public Type responseType() {
                return nextAdapter.responseType();
            }

            public Object adapt(Call<Object> call) {
                return nextAdapter.adapt(RetrofitRetry.decorateCall(RetryCallAdapter.this.retry, call));
            }
        };
    }
}

