/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retrofit;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.retrofit.RetrofitCircuitBreaker;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class CircuitBreakerCallAdapter
extends CallAdapter.Factory {
    private final CircuitBreaker circuitBreaker;
    private final Predicate<Response> successResponse;

    private CircuitBreakerCallAdapter(CircuitBreaker circuitBreaker, Predicate<Response> successResponse) {
        this.circuitBreaker = circuitBreaker;
        this.successResponse = successResponse;
    }

    public static CircuitBreakerCallAdapter of(CircuitBreaker circuitBreaker) {
        return CircuitBreakerCallAdapter.of(circuitBreaker, Response::isSuccessful);
    }

    public static CircuitBreakerCallAdapter of(CircuitBreaker circuitBreaker, Predicate<Response> successResponse) {
        return new CircuitBreakerCallAdapter(circuitBreaker, successResponse);
    }

    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        final CallAdapter nextAdapter = retrofit.nextCallAdapter((CallAdapter.Factory)this, returnType, annotations);
        return new CallAdapter<Object, Object>(){

            public Type responseType() {
                return nextAdapter.responseType();
            }

            public Object adapt(Call<Object> call) {
                return nextAdapter.adapt(RetrofitCircuitBreaker.decorateCall(CircuitBreakerCallAdapter.this.circuitBreaker, call, CircuitBreakerCallAdapter.this.successResponse));
            }
        };
    }
}

