/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retrofit;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.retrofit.internal.DecoratedCall;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public interface RetrofitRateLimiter {
    public static <T> Call<T> decorateCall(RateLimiter rateLimiter, Call<T> call) {
        return new RateLimitingCall<T>(call, rateLimiter);
    }

    public static class RateLimitingCall<T>
    extends DecoratedCall<T> {
        private final Call<T> call;
        private final RateLimiter rateLimiter;

        public RateLimitingCall(Call<T> call, RateLimiter rateLimiter) {
            super(call);
            this.call = call;
            this.rateLimiter = rateLimiter;
        }

        @Override
        public void enqueue(Callback<T> callback) {
            try {
                RateLimiter.waitForPermission((RateLimiter)this.rateLimiter);
            }
            catch (RequestNotPermitted | IllegalStateException e) {
                callback.onResponse(this.call, this.tooManyRequestsError());
                return;
            }
            this.call.enqueue(callback);
        }

        @Override
        public Response<T> execute() throws IOException {
            CheckedFunction0 restrictedSupplier = RateLimiter.decorateCheckedSupplier((RateLimiter)this.rateLimiter, () -> this.call.execute());
            Try response = Try.of((CheckedFunction0)restrictedSupplier);
            return response.isSuccess() ? (Response<T>)response.get() : this.handleFailure(response);
        }

        private Response<T> handleFailure(Try<Response<T>> response) throws IOException {
            try {
                throw response.getCause();
            }
            catch (RequestNotPermitted | IllegalStateException e) {
                return this.tooManyRequestsError();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Throwable t) {
                throw new RuntimeException("Exception executing call", t);
            }
        }

        private Response<T> tooManyRequestsError() {
            return Response.error((int)429, (ResponseBody)ResponseBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)"Too many requests for the client"));
        }

        @Override
        public Call<T> clone() {
            return new RateLimitingCall<T>(this.call.clone(), this.rateLimiter);
        }
    }
}

