/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.timelimiter.monitoring.endpoint;

import io.github.resilience4j.common.timelimiter.monitoring.endpoint.TimeLimiterEventDTO;
import io.github.resilience4j.common.timelimiter.monitoring.endpoint.TimeLimiterEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventPublisher;
import io.github.resilience4j.ratpack.Resilience4jConfig;
import io.github.resilience4j.reactor.adapter.ReactorAdapter;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.github.resilience4j.timelimiter.event.TimeLimiterEvent;
import io.vavr.collection.Seq;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import org.reactivestreams.Publisher;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.Chain;
import ratpack.jackson.Jackson;
import ratpack.registry.Registry;
import ratpack.sse.ServerSentEvents;
import reactor.core.publisher.Flux;

public class TimeLimiterChain
implements Action<Chain> {
    private final EventConsumerRegistry<TimeLimiterEvent> eventConsumerRegistry;
    private final TimeLimiterRegistry timeLimiterRegistry;

    @Inject
    public TimeLimiterChain(EventConsumerRegistry<TimeLimiterEvent> eventConsumerRegistry, TimeLimiterRegistry timeLimiterRegistry) {
        this.eventConsumerRegistry = eventConsumerRegistry;
        this.timeLimiterRegistry = timeLimiterRegistry;
    }

    public void execute(Chain chain) throws Exception {
        String prefix = ((Resilience4jConfig)chain.getRegistry().get(Resilience4jConfig.class)).getEndpoints().getTimelimiter().getPath();
        chain.prefix(prefix, chain1 -> {
            chain1.get("events", ctx -> Promise.async(d -> {
                List eventsList = this.eventConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(TimeLimiterEvent::getCreationTime)).map(TimeLimiterEventDTO::createTimeLimiterEventDTO).toJavaList();
                d.success((Object)new TimeLimiterEventsEndpointResponse(eventsList));
            }).then(r -> ctx.render((Object)Jackson.json((Object)r))));
            chain1.get("stream/events", ctx -> {
                Seq eventStreams = this.timeLimiterRegistry.getAllTimeLimiters().map(timeLimiter -> ReactorAdapter.toFlux((EventPublisher)timeLimiter.getEventPublisher()));
                Function data = r -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)TimeLimiterEventDTO.createTimeLimiterEventDTO((TimeLimiterEvent)r));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)Flux.merge((Iterable)eventStreams), e -> e.id(TimeLimiterEvent::getTimeLimiterName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
            chain1.get("events/:name", ctx -> {
                String timeLimiterName = (String)ctx.getPathTokens().get((Object)"name");
                Promise.async(d -> {
                    List eventsList = this.eventConsumerRegistry.getEventConsumer(timeLimiterName).getBufferedEvents().sorted(Comparator.comparing(TimeLimiterEvent::getCreationTime)).map(TimeLimiterEventDTO::createTimeLimiterEventDTO).toJavaList();
                    d.success((Object)new TimeLimiterEventsEndpointResponse(eventsList));
                }).then(r -> ctx.render((Object)Jackson.json((Object)r)));
            });
            chain1.get("stream/events/:name", ctx -> {
                String timeLimiterName = (String)ctx.getPathTokens().get((Object)"name");
                TimeLimiter timeLimiter = (TimeLimiter)this.timeLimiterRegistry.getAllTimeLimiters().find(tL -> tL.getName().equals(timeLimiterName)).getOrElseThrow(() -> new IllegalArgumentException(String.format("time limiter with name %s not found", timeLimiterName)));
                Function data = r -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)TimeLimiterEventDTO.createTimeLimiterEventDTO((TimeLimiterEvent)r));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)ReactorAdapter.toFlux((EventPublisher)timeLimiter.getEventPublisher()), e -> e.id(TimeLimiterEvent::getTimeLimiterName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
            chain1.get("events/:name/:type", ctx -> {
                String timeLimiterName = (String)ctx.getPathTokens().get((Object)"name");
                String eventType = (String)ctx.getPathTokens().get((Object)"type");
                Promise.async(d -> {
                    List eventsList = this.eventConsumerRegistry.getEventConsumer(timeLimiterName).getBufferedEvents().sorted(Comparator.comparing(TimeLimiterEvent::getCreationTime)).filter(event -> event.getEventType() == TimeLimiterEvent.Type.valueOf((String)eventType.toUpperCase())).map(TimeLimiterEventDTO::createTimeLimiterEventDTO).toJavaList();
                    d.success((Object)new TimeLimiterEventsEndpointResponse(eventsList));
                }).then(r -> ctx.render((Object)Jackson.json((Object)r)));
            });
            chain1.get("stream/events/:name/:type", ctx -> {
                String timeLimiterName = (String)ctx.getPathTokens().get((Object)"name");
                String eventType = (String)ctx.getPathTokens().get((Object)"type");
                TimeLimiter timeLimiter = (TimeLimiter)this.timeLimiterRegistry.getAllTimeLimiters().find(rL -> rL.getName().equals(timeLimiterName)).getOrElseThrow(() -> new IllegalArgumentException(String.format("time limiter with name %s not found", timeLimiterName)));
                Flux eventStream = ReactorAdapter.toFlux((EventPublisher)timeLimiter.getEventPublisher()).filter(event -> event.getEventType() == TimeLimiterEvent.Type.valueOf((String)eventType.toUpperCase()));
                Function data = r -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)TimeLimiterEventDTO.createTimeLimiterEventDTO((TimeLimiterEvent)r));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)eventStream, e -> e.id(TimeLimiterEvent::getTimeLimiterName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
        });
    }
}

