/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.retry.monitoring.endpoint;

import io.github.resilience4j.common.retry.monitoring.endpoint.RetryEventDTOFactory;
import io.github.resilience4j.common.retry.monitoring.endpoint.RetryEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventPublisher;
import io.github.resilience4j.ratpack.Resilience4jConfig;
import io.github.resilience4j.reactor.adapter.ReactorAdapter;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.event.RetryEvent;
import io.vavr.collection.Seq;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import org.reactivestreams.Publisher;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.Chain;
import ratpack.jackson.Jackson;
import ratpack.registry.Registry;
import ratpack.sse.ServerSentEvents;
import reactor.core.publisher.Flux;

public class RetryChain
implements Action<Chain> {
    private final EventConsumerRegistry<RetryEvent> eventConsumerRegistry;
    private final RetryRegistry retryRegistry;

    @Inject
    public RetryChain(EventConsumerRegistry<RetryEvent> eventConsumerRegistry, RetryRegistry retryRegistry) {
        this.eventConsumerRegistry = eventConsumerRegistry;
        this.retryRegistry = retryRegistry;
    }

    public void execute(Chain chain) throws Exception {
        String prefix = ((Resilience4jConfig)chain.getRegistry().get(Resilience4jConfig.class)).getEndpoints().getRetry().getPath();
        chain.prefix(prefix, chain1 -> {
            chain1.get("events", ctx -> Promise.async(d -> {
                List eventsList = this.eventConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(RetryEvent::getCreationTime)).map(RetryEventDTOFactory::createRetryEventDTO).toJavaList();
                d.success((Object)new RetryEventsEndpointResponse(eventsList));
            }).then(r -> ctx.render((Object)Jackson.json((Object)r))));
            chain1.get("stream/events", ctx -> {
                Seq eventStreams = this.retryRegistry.getAllRetries().map(retry -> ReactorAdapter.toFlux((EventPublisher)retry.getEventPublisher()));
                Function data = r -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)RetryEventDTOFactory.createRetryEventDTO((RetryEvent)r));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)Flux.merge((Iterable)eventStreams), e -> e.id(RetryEvent::getName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
            chain1.get("events/:name", ctx -> {
                String retryName = (String)ctx.getPathTokens().get((Object)"name");
                Promise.async(d -> {
                    List eventsList = this.eventConsumerRegistry.getEventConsumer(retryName).getBufferedEvents().sorted(Comparator.comparing(RetryEvent::getCreationTime)).map(RetryEventDTOFactory::createRetryEventDTO).toJavaList();
                    d.success((Object)new RetryEventsEndpointResponse(eventsList));
                }).then(r -> ctx.render((Object)Jackson.json((Object)r)));
            });
            chain1.get("stream/events/:name", ctx -> {
                String rateLimiterName = (String)ctx.getPathTokens().get((Object)"name");
                Retry retry = (Retry)this.retryRegistry.getAllRetries().find(rL -> rL.getName().equals(rateLimiterName)).getOrElseThrow(() -> new IllegalArgumentException(String.format("rate limiter with name %s not found", rateLimiterName)));
                Function data = r -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)RetryEventDTOFactory.createRetryEventDTO((RetryEvent)r));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)ReactorAdapter.toFlux((EventPublisher)retry.getEventPublisher()), e -> e.id(RetryEvent::getName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
            chain1.get("events/:name/:type", ctx -> {
                String retryName = (String)ctx.getPathTokens().get((Object)"name");
                String eventType = (String)ctx.getPathTokens().get((Object)"type");
                Promise.async(d -> {
                    List eventsList = this.eventConsumerRegistry.getEventConsumer(retryName).getBufferedEvents().sorted(Comparator.comparing(RetryEvent::getCreationTime)).filter(event -> event.getEventType() == RetryEvent.Type.valueOf((String)eventType.toUpperCase())).map(RetryEventDTOFactory::createRetryEventDTO).toJavaList();
                    d.success((Object)new RetryEventsEndpointResponse(eventsList));
                }).then(r -> ctx.render((Object)Jackson.json((Object)r)));
            });
            chain1.get("stream/events/:name/:type", ctx -> {
                String retryName = (String)ctx.getPathTokens().get((Object)"name");
                String eventType = (String)ctx.getPathTokens().get((Object)"type");
                Retry retry = (Retry)this.retryRegistry.getAllRetries().find(rL -> rL.getName().equals(retryName)).getOrElseThrow(() -> new IllegalArgumentException(String.format("rate limiter with name %s not found", retryName)));
                Flux eventStream = ReactorAdapter.toFlux((EventPublisher)retry.getEventPublisher()).filter(event -> event.getEventType() == RetryEvent.Type.valueOf((String)eventType.toUpperCase()));
                Function data = r -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)RetryEventDTOFactory.createRetryEventDTO((RetryEvent)r));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)eventStream, e -> e.id(RetryEvent::getName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
        });
    }
}

