/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.retry;

import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.ratpack.internal.AbstractTransformer;
import io.github.resilience4j.retry.Retry;
import ratpack.exec.Downstream;
import ratpack.exec.Upstream;
import ratpack.func.Function;

public class RetryTransformer<T>
extends AbstractTransformer<T> {
    private final Retry retry;

    private RetryTransformer(Retry retry) {
        this.retry = retry;
    }

    public static <T> RetryTransformer<T> of(Retry retry) {
        return new RetryTransformer<T>(retry);
    }

    public RetryTransformer<T> recover(@Nullable Function<Throwable, ? extends T> recoverer) {
        this.recoverer = recoverer;
        return this;
    }

    public Upstream<T> apply(final Upstream<? extends T> upstream) {
        return down -> {
            final Retry.Context context = this.retry.context();
            Downstream downstream = new Downstream<T>(){

                public void success(T value) {
                    context.onComplete();
                    down.success(value);
                }

                public void error(Throwable throwable) {
                    try {
                        context.onError((Exception)throwable);
                        upstream.connect((Downstream)this);
                    }
                    catch (Exception ex1) {
                        if (RetryTransformer.this.recoverer != null) {
                            try {
                                down.success(RetryTransformer.this.recoverer.apply((Object)ex1));
                            }
                            catch (Exception ex2) {
                                down.error((Throwable)ex2);
                            }
                        }
                        down.error((Throwable)ex1);
                    }
                }

                public void complete() {
                    down.complete();
                }
            };
            upstream.connect(downstream);
        };
    }
}

