/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.ratelimiter;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.ratpack.internal.AbstractTransformer;
import ratpack.exec.Downstream;
import ratpack.exec.Upstream;
import ratpack.func.Function;

public class RateLimiterTransformer<T>
extends AbstractTransformer<T> {
    private final RateLimiter rateLimiter;

    private RateLimiterTransformer(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public static <T> RateLimiterTransformer<T> of(RateLimiter rateLimiter) {
        return new RateLimiterTransformer<T>(rateLimiter);
    }

    public RateLimiterTransformer<T> recover(Function<Throwable, ? extends T> recoverer) {
        this.recoverer = recoverer;
        return this;
    }

    public Upstream<T> apply(Upstream<? extends T> upstream) throws Exception {
        return down -> {
            boolean permission = this.rateLimiter.acquirePermission();
            if (Thread.interrupted()) {
                throw new IllegalStateException("Thread was interrupted during permission wait");
            }
            if (!permission) {
                RequestNotPermitted t = RequestNotPermitted.createRequestNotPermitted((RateLimiter)this.rateLimiter);
                if (this.recoverer != null) {
                    down.success(this.recoverer.apply((Object)t));
                } else {
                    down.error((Throwable)t);
                }
            } else {
                upstream.connect(new Downstream<T>(){

                    public void success(T value) {
                        down.success(value);
                    }

                    public void error(Throwable throwable) {
                        down.error(throwable);
                    }

                    public void complete() {
                        down.complete();
                    }
                });
            }
        };
    }
}

