/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.ratelimiter;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import ratpack.handling.Context;
import ratpack.handling.Handler;

public class RateLimiterHandler
implements Handler {
    private final RateLimiter rateLimiter;

    public RateLimiterHandler(RateLimiterRegistry rateLimiterRegistry, String rateLimiterName) {
        this.rateLimiter = rateLimiterRegistry.rateLimiter(rateLimiterName);
    }

    public RateLimiterHandler(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public void handle(Context ctx) throws Exception {
        boolean permission = this.rateLimiter.acquirePermission();
        if (Thread.interrupted()) {
            throw new IllegalStateException("Thread was interrupted during permission wait");
        }
        if (!permission) {
            RequestNotPermitted t = RequestNotPermitted.createRequestNotPermitted((RateLimiter)this.rateLimiter);
            ctx.error((Throwable)t);
        } else {
            ctx.next();
        }
    }
}

