/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.circuitbreaker;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.ratpack.internal.AbstractTransformer;
import java.util.concurrent.TimeUnit;
import ratpack.exec.Downstream;
import ratpack.exec.Upstream;
import ratpack.func.Function;

public class CircuitBreakerTransformer<T>
extends AbstractTransformer<T> {
    private CircuitBreaker circuitBreaker;

    private CircuitBreakerTransformer(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public static <T> CircuitBreakerTransformer<T> of(CircuitBreaker circuitBreaker) {
        return new CircuitBreakerTransformer<T>(circuitBreaker);
    }

    public CircuitBreakerTransformer<T> recover(Function<Throwable, ? extends T> recoverer) {
        this.recoverer = recoverer;
        return this;
    }

    public Upstream<T> apply(Upstream<? extends T> upstream) throws Exception {
        return down -> {
            if (this.circuitBreaker.tryAcquirePermission()) {
                final long start = System.nanoTime();
                upstream.connect(new Downstream<T>(){

                    public void success(T value) {
                        long durationInNanos = System.nanoTime() - start;
                        CircuitBreakerTransformer.this.circuitBreaker.onResult(durationInNanos, TimeUnit.NANOSECONDS, value);
                        down.success(value);
                    }

                    public void error(Throwable throwable) {
                        long durationInNanos = System.nanoTime() - start;
                        CircuitBreakerTransformer.this.circuitBreaker.onError(durationInNanos, TimeUnit.NANOSECONDS, throwable);
                        CircuitBreakerTransformer.this.handleRecovery(down, throwable);
                    }

                    public void complete() {
                        CircuitBreakerTransformer.this.circuitBreaker.releasePermission();
                        down.complete();
                    }
                });
            } else {
                CallNotPermittedException t = CallNotPermittedException.createCallNotPermittedException((CircuitBreaker)this.circuitBreaker);
                this.handleRecovery(down, (Throwable)t);
            }
        };
    }
}

