/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.circuitbreaker;

import com.google.inject.Inject;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.ratpack.circuitbreaker.CircuitBreakerTransformer;
import io.github.resilience4j.ratpack.internal.AbstractMethodInterceptor;
import io.github.resilience4j.ratpack.recovery.DefaultRecoveryFunction;
import io.github.resilience4j.ratpack.recovery.RecoveryFunction;
import io.github.resilience4j.reactor.circuitbreaker.operator.CircuitBreakerOperator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.aopalliance.intercept.MethodInvocation;
import ratpack.exec.Promise;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CircuitBreakerMethodInterceptor
extends AbstractMethodInterceptor {
    @Inject(optional=true)
    @Nullable
    private CircuitBreakerRegistry registry;

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker annotation = invocation.getMethod().getAnnotation(io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker.class);
        if (annotation == null) {
            annotation = invocation.getMethod().getDeclaringClass().getAnnotation(io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker.class);
        }
        RecoveryFunction fallbackMethod = Optional.ofNullable(this.createRecoveryFunction(invocation, annotation.fallbackMethod())).orElse(new DefaultRecoveryFunction());
        if (this.registry == null) {
            this.registry = CircuitBreakerRegistry.ofDefaults();
        }
        CircuitBreaker breaker = this.registry.circuitBreaker(annotation.name());
        Class<?> returnType = invocation.getMethod().getReturnType();
        if (Promise.class.isAssignableFrom(returnType)) {
            Promise result = (Promise)this.proceed(invocation, breaker);
            if (result != null) {
                CircuitBreakerTransformer transformer = CircuitBreakerTransformer.of(breaker).recover(fallbackMethod);
                result = result.transform(transformer);
            }
            return result;
        }
        if (Flux.class.isAssignableFrom(returnType)) {
            Flux result = (Flux)this.proceed(invocation, breaker);
            if (result != null) {
                CircuitBreakerOperator operator = CircuitBreakerOperator.of((CircuitBreaker)breaker);
                result = fallbackMethod.onErrorResume(result.transform((Function)operator));
            }
            return result;
        }
        if (Mono.class.isAssignableFrom(returnType)) {
            Mono result = (Mono)this.proceed(invocation, breaker);
            if (result != null) {
                CircuitBreakerOperator operator = CircuitBreakerOperator.of((CircuitBreaker)breaker);
                result = fallbackMethod.onErrorResume(result.transform((Function)operator));
            }
            return result;
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            CompletableFuture promise = new CompletableFuture();
            if (breaker.tryAcquirePermission()) {
                CompletionStage result = (CompletionStage)this.proceed(invocation, breaker);
                if (result != null) {
                    long start = System.nanoTime();
                    result.whenComplete((v, t) -> {
                        long durationInNanos = System.nanoTime() - start;
                        if (t != null) {
                            breaker.onError(durationInNanos, TimeUnit.NANOSECONDS, t);
                            this.completeFailedFuture((Throwable)t, fallbackMethod, promise);
                        } else {
                            breaker.onResult(durationInNanos, TimeUnit.NANOSECONDS, v);
                            promise.complete(v);
                        }
                    });
                }
            } else {
                CallNotPermittedException t2 = CallNotPermittedException.createCallNotPermittedException((CircuitBreaker)breaker);
                this.completeFailedFuture((Throwable)t2, fallbackMethod, promise);
            }
            return promise;
        }
        return this.handleProceedWithException(invocation, breaker, fallbackMethod);
    }

    @Nullable
    private Object proceed(MethodInvocation invocation, CircuitBreaker breaker) throws Throwable {
        Object result;
        Class<?> returnType = invocation.getMethod().getReturnType();
        long start = System.nanoTime();
        try {
            result = invocation.proceed();
        }
        catch (Exception e) {
            long durationInNanos = System.nanoTime() - start;
            breaker.onError(durationInNanos, TimeUnit.NANOSECONDS, (Throwable)e);
            if (Promise.class.isAssignableFrom(returnType)) {
                return Promise.error((Throwable)e);
            }
            if (Flux.class.isAssignableFrom(returnType)) {
                return Flux.error((Throwable)e);
            }
            if (Mono.class.isAssignableFrom(returnType)) {
                return Mono.error((Throwable)e);
            }
            if (CompletionStage.class.isAssignableFrom(returnType)) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(e);
                return future;
            }
            throw e;
        }
        return result;
    }

    @Nullable
    private Object handleProceedWithException(MethodInvocation invocation, CircuitBreaker breaker, RecoveryFunction<?> recoveryFunction) throws Throwable {
        try {
            return CircuitBreaker.decorateCheckedSupplier((CircuitBreaker)breaker, () -> ((MethodInvocation)invocation).proceed()).apply();
        }
        catch (Throwable throwable) {
            return recoveryFunction.apply(throwable);
        }
    }
}

