/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.bulkhead.configuration.BulkheadConfigurationProperties;
import io.github.resilience4j.common.bulkhead.configuration.ThreadPoolBulkheadConfigurationProperties;
import io.github.resilience4j.common.circuitbreaker.configuration.CircuitBreakerConfigurationProperties;
import io.github.resilience4j.common.ratelimiter.configuration.RateLimiterConfigurationProperties;
import io.github.resilience4j.common.retry.configuration.RetryConfigurationProperties;
import io.github.resilience4j.common.timelimiter.configuration.TimeLimiterConfigurationProperties;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.metrics.BulkheadMetrics;
import io.github.resilience4j.metrics.CircuitBreakerMetrics;
import io.github.resilience4j.metrics.RateLimiterMetrics;
import io.github.resilience4j.metrics.RetryMetrics;
import io.github.resilience4j.metrics.ThreadPoolBulkheadMetrics;
import io.github.resilience4j.prometheus.collectors.BulkheadMetricsCollector;
import io.github.resilience4j.prometheus.collectors.CircuitBreakerMetricsCollector;
import io.github.resilience4j.prometheus.collectors.RateLimiterMetricsCollector;
import io.github.resilience4j.prometheus.collectors.RetryMetricsCollector;
import io.github.resilience4j.prometheus.collectors.ThreadPoolBulkheadMetricsCollector;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import io.github.resilience4j.ratpack.EndpointsConfig;
import io.github.resilience4j.ratpack.Resilience4jConfig;
import io.github.resilience4j.ratpack.bulkhead.BulkheadMethodInterceptor;
import io.github.resilience4j.ratpack.bulkhead.monitoring.endpoint.BulkheadChain;
import io.github.resilience4j.ratpack.circuitbreaker.CircuitBreakerMethodInterceptor;
import io.github.resilience4j.ratpack.circuitbreaker.monitoring.endpoint.CircuitBreakerChain;
import io.github.resilience4j.ratpack.ratelimiter.RateLimiterMethodInterceptor;
import io.github.resilience4j.ratpack.ratelimiter.monitoring.endpoint.RateLimiterChain;
import io.github.resilience4j.ratpack.retry.RetryMethodInterceptor;
import io.github.resilience4j.ratpack.retry.monitoring.endpoint.RetryChain;
import io.github.resilience4j.ratpack.timelimiter.TimeLimiterMethodInterceptor;
import io.github.resilience4j.ratpack.timelimiter.monitoring.endpoint.TimeLimiterChain;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.github.resilience4j.timelimiter.annotation.TimeLimiter;
import io.github.resilience4j.timelimiter.event.TimeLimiterEvent;
import io.prometheus.client.CollectorRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import org.aopalliance.intercept.MethodInterceptor;
import ratpack.func.Action;
import ratpack.guice.ConfigurableModule;
import ratpack.handling.Handler;
import ratpack.handling.HandlerDecorator;
import ratpack.handling.Handlers;
import ratpack.registry.Registry;
import ratpack.service.Service;
import ratpack.service.StartEvent;

public class Resilience4jModule
extends ConfigurableModule<Resilience4jConfig> {
    protected void configure() {
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(CircuitBreaker.class), new MethodInterceptor[]{this.injected(new CircuitBreakerMethodInterceptor())});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(io.github.resilience4j.ratelimiter.annotation.RateLimiter.class), new MethodInterceptor[]{this.injected(new RateLimiterMethodInterceptor())});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(io.github.resilience4j.retry.annotation.Retry.class), new MethodInterceptor[]{this.injected(new RetryMethodInterceptor())});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(io.github.resilience4j.bulkhead.annotation.Bulkhead.class), new MethodInterceptor[]{this.injected(new BulkheadMethodInterceptor())});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(TimeLimiter.class), new MethodInterceptor[]{this.injected(new TimeLimiterMethodInterceptor())});
        this.bindInterceptor(Matchers.annotatedWith(CircuitBreaker.class), Matchers.any(), new MethodInterceptor[]{this.injected(new CircuitBreakerMethodInterceptor())});
        this.bindInterceptor(Matchers.annotatedWith(io.github.resilience4j.ratelimiter.annotation.RateLimiter.class), Matchers.any(), new MethodInterceptor[]{this.injected(new RateLimiterMethodInterceptor())});
        this.bindInterceptor(Matchers.annotatedWith(io.github.resilience4j.retry.annotation.Retry.class), Matchers.any(), new MethodInterceptor[]{this.injected(new RetryMethodInterceptor())});
        this.bindInterceptor(Matchers.annotatedWith(io.github.resilience4j.bulkhead.annotation.Bulkhead.class), Matchers.any(), new MethodInterceptor[]{this.injected(new BulkheadMethodInterceptor())});
        this.bindInterceptor(Matchers.annotatedWith(TimeLimiter.class), Matchers.any(), new MethodInterceptor[]{this.injected(new TimeLimiterMethodInterceptor())});
        OptionalBinder.newOptionalBinder((Binder)this.binder(), CircuitBreakerRegistry.class).setDefault().toProvider(CircuitBreakerRegistryProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), RateLimiterRegistry.class).setDefault().toProvider(RateLimiterRegistryProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), RetryRegistry.class).setDefault().toProvider(RetryRegistryProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), BulkheadRegistry.class).setDefault().toProvider(BulkheadRegistryProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), ThreadPoolBulkheadRegistry.class).setDefault().toProvider(ThreadPoolBulkheadRegistryProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), TimeLimiterRegistry.class).setDefault().toProvider(TimeLimiterRegistryProvider.class).in(Scopes.SINGLETON);
        this.bind((TypeLiteral)new TypeLiteral<EventConsumerRegistry<CircuitBreakerEvent>>(){}).toInstance((Object)new DefaultEventConsumerRegistry());
        this.bind((TypeLiteral)new TypeLiteral<EventConsumerRegistry<RateLimiterEvent>>(){}).toInstance((Object)new DefaultEventConsumerRegistry());
        this.bind((TypeLiteral)new TypeLiteral<EventConsumerRegistry<RetryEvent>>(){}).toInstance((Object)new DefaultEventConsumerRegistry());
        this.bind((TypeLiteral)new TypeLiteral<EventConsumerRegistry<BulkheadEvent>>(){}).toInstance((Object)new DefaultEventConsumerRegistry());
        this.bind((TypeLiteral)new TypeLiteral<EventConsumerRegistry<TimeLimiterEvent>>(){}).toInstance((Object)new DefaultEventConsumerRegistry());
        Multibinder binder = Multibinder.newSetBinder((Binder)this.binder(), HandlerDecorator.class);
        this.bind(CircuitBreakerChain.class).in(Scopes.SINGLETON);
        this.bind(RateLimiterChain.class).in(Scopes.SINGLETON);
        this.bind(RetryChain.class).in(Scopes.SINGLETON);
        this.bind(BulkheadChain.class).in(Scopes.SINGLETON);
        this.bind(TimeLimiterChain.class).in(Scopes.SINGLETON);
        binder.addBinding().toProvider(() -> (registry, rest) -> {
            if (((Resilience4jConfig)registry.get(Resilience4jConfig.class)).getEndpoints().getCircuitbreaker().isEnabled()) {
                return Handlers.chain((Handler[])new Handler[]{Handlers.chain((Registry)registry, (Action)((Action)registry.get(CircuitBreakerChain.class))), rest});
            }
            return rest;
        });
        binder.addBinding().toProvider(() -> (registry, rest) -> {
            if (((Resilience4jConfig)registry.get(Resilience4jConfig.class)).getEndpoints().getRatelimiter().isEnabled()) {
                return Handlers.chain((Handler[])new Handler[]{Handlers.chain((Registry)registry, (Action)((Action)registry.get(RateLimiterChain.class))), rest});
            }
            return rest;
        });
        binder.addBinding().toProvider(() -> (registry, rest) -> {
            if (((Resilience4jConfig)registry.get(Resilience4jConfig.class)).getEndpoints().getRetry().isEnabled()) {
                return Handlers.chain((Handler[])new Handler[]{Handlers.chain((Registry)registry, (Action)((Action)registry.get(RetryChain.class))), rest});
            }
            return rest;
        });
        binder.addBinding().toProvider(() -> (registry, rest) -> {
            if (((Resilience4jConfig)registry.get(Resilience4jConfig.class)).getEndpoints().getBulkhead().isEnabled()) {
                return Handlers.chain((Handler[])new Handler[]{Handlers.chain((Registry)registry, (Action)((Action)registry.get(BulkheadChain.class))), rest});
            }
            return rest;
        });
        binder.addBinding().toProvider(() -> (registry, rest) -> {
            if (((Resilience4jConfig)registry.get(Resilience4jConfig.class)).getEndpoints().getTimelimiter().isEnabled()) {
                return Handlers.chain((Handler[])new Handler[]{Handlers.chain((Registry)registry, (Action)((Action)registry.get(TimeLimiterChain.class))), rest});
            }
            return rest;
        });
        this.bind(Resilience4jService.class).in(Scopes.SINGLETON);
    }

    private <T> T injected(T instance) {
        this.requestInjection(instance);
        return instance;
    }

    private static class Resilience4jService
    implements Service {
        private Resilience4jService() {
        }

        public void onStart(StartEvent event) {
            Registry registry = event.getRegistry();
            Resilience4jConfig resilience4jConfig = (Resilience4jConfig)registry.get(Resilience4jConfig.class);
            CircuitBreakerRegistry circuitBreakerRegistry = (CircuitBreakerRegistry)registry.get(CircuitBreakerRegistry.class);
            RateLimiterRegistry rateLimiterRegistry = (RateLimiterRegistry)registry.get(RateLimiterRegistry.class);
            RetryRegistry retryRegistry = (RetryRegistry)registry.get(RetryRegistry.class);
            BulkheadRegistry bulkheadRegistry = (BulkheadRegistry)registry.get(BulkheadRegistry.class);
            ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry = (ThreadPoolBulkheadRegistry)registry.get(ThreadPoolBulkheadRegistry.class);
            if (resilience4jConfig.isMetrics() && registry.maybeGet(MetricRegistry.class).isPresent()) {
                MetricRegistry metricRegistry = (MetricRegistry)registry.get(MetricRegistry.class);
                CircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerRegistry)circuitBreakerRegistry, (MetricRegistry)metricRegistry);
                RateLimiterMetrics.ofRateLimiterRegistry((RateLimiterRegistry)rateLimiterRegistry, (MetricRegistry)metricRegistry);
                RetryMetrics.ofRetryRegistry((RetryRegistry)retryRegistry, (MetricRegistry)metricRegistry);
                BulkheadMetrics.ofBulkheadRegistry((BulkheadRegistry)bulkheadRegistry, (MetricRegistry)metricRegistry);
                ThreadPoolBulkheadMetrics.ofBulkheadRegistry((ThreadPoolBulkheadRegistry)threadPoolBulkheadRegistry, (MetricRegistry)metricRegistry);
            }
            if (resilience4jConfig.isPrometheus() && registry.maybeGet(CollectorRegistry.class).isPresent()) {
                CollectorRegistry collectorRegistry = (CollectorRegistry)registry.get(CollectorRegistry.class);
                CircuitBreakerMetricsCollector circuitBreakerMetricsCollector = CircuitBreakerMetricsCollector.ofCircuitBreakerRegistry((CircuitBreakerRegistry)circuitBreakerRegistry);
                RetryMetricsCollector retryMetricsCollector = RetryMetricsCollector.ofRetryRegistry((RetryRegistry)retryRegistry);
                RateLimiterMetricsCollector rateLimiterMetricsCollector = RateLimiterMetricsCollector.ofRateLimiterRegistry((RateLimiterRegistry)rateLimiterRegistry);
                BulkheadMetricsCollector bulkheadMetricsCollector = BulkheadMetricsCollector.ofBulkheadRegistry((BulkheadRegistry)bulkheadRegistry);
                ThreadPoolBulkheadMetricsCollector threadPoolBulkheadMetricsCollector = ThreadPoolBulkheadMetricsCollector.ofBulkheadRegistry((ThreadPoolBulkheadRegistry)threadPoolBulkheadRegistry);
                circuitBreakerMetricsCollector.register(collectorRegistry);
                retryMetricsCollector.register(collectorRegistry);
                rateLimiterMetricsCollector.register(collectorRegistry);
                bulkheadMetricsCollector.register(collectorRegistry);
                threadPoolBulkheadMetricsCollector.register(collectorRegistry);
            }
        }
    }

    private static class TimeLimiterRegistryProvider
    implements Provider<TimeLimiterRegistry> {
        private Resilience4jConfig resilience4jConfig;
        private EventConsumerRegistry<TimeLimiterEvent> eventConsumerRegistry;

        @Inject
        public TimeLimiterRegistryProvider(Resilience4jConfig resilience4jConfig, EventConsumerRegistry<TimeLimiterEvent> eventConsumerRegistry) {
            this.resilience4jConfig = resilience4jConfig;
            this.eventConsumerRegistry = eventConsumerRegistry;
        }

        public TimeLimiterRegistry get() {
            TimeLimiterConfigurationProperties timeLimiterProperties = this.resilience4jConfig.getTimeLimiter();
            Map<String, TimeLimiterConfig> configs = timeLimiterProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> timeLimiterProperties.createTimeLimiterConfig((String)entry.getKey(), (TimeLimiterConfigurationProperties.InstanceProperties)entry.getValue(), new CompositeCustomizer(Collections.emptyList()))));
            TimeLimiterRegistry timeLimiterRegistry = TimeLimiterRegistry.of(configs);
            EndpointsConfig endpointsConfig = this.resilience4jConfig.getEndpoints();
            timeLimiterProperties.getInstances().forEach((name, timeLimiterConfig) -> {
                io.github.resilience4j.timelimiter.TimeLimiter timeLimiter = timeLimiterRegistry.timeLimiter(name, timeLimiterProperties.createTimeLimiterConfig(name, timeLimiterConfig, new CompositeCustomizer(Collections.emptyList())));
                if (endpointsConfig.getTimelimiter().isEnabled()) {
                    timeLimiter.getEventPublisher().onEvent((EventConsumer)this.eventConsumerRegistry.createEventConsumer(name, timeLimiterConfig.getEventConsumerBufferSize() != null ? timeLimiterConfig.getEventConsumerBufferSize() : 100));
                }
            });
            return timeLimiterRegistry;
        }
    }

    private static class ThreadPoolBulkheadRegistryProvider
    implements Provider<ThreadPoolBulkheadRegistry> {
        private Resilience4jConfig resilience4jConfig;
        private EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry;

        @Inject
        public ThreadPoolBulkheadRegistryProvider(Resilience4jConfig resilience4jConfig, EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry) {
            this.resilience4jConfig = resilience4jConfig;
            this.eventConsumerRegistry = eventConsumerRegistry;
        }

        public ThreadPoolBulkheadRegistry get() {
            ThreadPoolBulkheadConfigurationProperties threadPoolBulkheadProperties = this.resilience4jConfig.getThreadpoolbulkhead();
            Map<String, ThreadPoolBulkheadConfig> configs = threadPoolBulkheadProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> threadPoolBulkheadProperties.createThreadPoolBulkheadConfig((ThreadPoolBulkheadConfigurationProperties.InstanceProperties)entry.getValue(), new CompositeCustomizer(Collections.emptyList()), (String)entry.getKey())));
            ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry = ThreadPoolBulkheadRegistry.of(configs);
            EndpointsConfig endpointsConfig = this.resilience4jConfig.getEndpoints();
            threadPoolBulkheadProperties.getInstances().forEach((name, threadPoolBulkheadConfig) -> {
                ThreadPoolBulkhead threadPoolBulkhead = threadPoolBulkheadRegistry.bulkhead(name, threadPoolBulkheadProperties.createThreadPoolBulkheadConfig(threadPoolBulkheadConfig, new CompositeCustomizer(Collections.emptyList()), name));
                if (endpointsConfig.getThreadpoolbulkhead().isEnabled()) {
                    threadPoolBulkhead.getEventPublisher().onEvent((EventConsumer)this.eventConsumerRegistry.createEventConsumer(name, threadPoolBulkheadConfig.getEventConsumerBufferSize() != null ? threadPoolBulkheadConfig.getEventConsumerBufferSize() : 100));
                }
            });
            return threadPoolBulkheadRegistry;
        }
    }

    private static class BulkheadRegistryProvider
    implements Provider<BulkheadRegistry> {
        private Resilience4jConfig resilience4jConfig;
        private EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry;

        @Inject
        public BulkheadRegistryProvider(Resilience4jConfig resilience4jConfig, EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry) {
            this.resilience4jConfig = resilience4jConfig;
            this.eventConsumerRegistry = eventConsumerRegistry;
        }

        public BulkheadRegistry get() {
            BulkheadConfigurationProperties bulkheadProperties = this.resilience4jConfig.getBulkhead();
            Map<String, BulkheadConfig> configs = bulkheadProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> bulkheadProperties.createBulkheadConfig((BulkheadConfigurationProperties.InstanceProperties)entry.getValue(), new CompositeCustomizer(Collections.emptyList()), (String)entry.getKey())));
            BulkheadRegistry bulkheadRegistry = BulkheadRegistry.of(configs);
            EndpointsConfig endpointsConfig = this.resilience4jConfig.getEndpoints();
            bulkheadProperties.getInstances().forEach((name, bulkheadConfig) -> {
                Bulkhead bulkhead = bulkheadRegistry.bulkhead(name, bulkheadProperties.createBulkheadConfig(bulkheadConfig, new CompositeCustomizer(Collections.emptyList()), name));
                if (endpointsConfig.getBulkhead().isEnabled()) {
                    bulkhead.getEventPublisher().onEvent((EventConsumer)this.eventConsumerRegistry.createEventConsumer(name, bulkheadConfig.getEventConsumerBufferSize() != null ? bulkheadConfig.getEventConsumerBufferSize() : 100));
                }
            });
            return bulkheadRegistry;
        }
    }

    private static class RetryRegistryProvider
    implements Provider<RetryRegistry> {
        private Resilience4jConfig resilience4jConfig;
        private EventConsumerRegistry<RetryEvent> eventConsumerRegistry;

        @Inject
        public RetryRegistryProvider(Resilience4jConfig resilience4jConfig, EventConsumerRegistry<RetryEvent> eventConsumerRegistry) {
            this.resilience4jConfig = resilience4jConfig;
            this.eventConsumerRegistry = eventConsumerRegistry;
        }

        public RetryRegistry get() {
            RetryConfigurationProperties RetryProperties = this.resilience4jConfig.getRetry();
            Map<String, RetryConfig> configs = RetryProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> RetryProperties.createRetryConfig((RetryConfigurationProperties.InstanceProperties)entry.getValue(), new CompositeCustomizer(Collections.emptyList()), (String)entry.getKey())));
            RetryRegistry retryRegistry = RetryRegistry.of(configs);
            EndpointsConfig endpointsConfig = this.resilience4jConfig.getEndpoints();
            RetryProperties.getInstances().forEach((name, retryConfig) -> {
                Retry retry = retryRegistry.retry(name, RetryProperties.createRetryConfig(retryConfig, new CompositeCustomizer(Collections.emptyList()), name));
                if (endpointsConfig.getRetry().isEnabled()) {
                    retry.getEventPublisher().onEvent((EventConsumer)this.eventConsumerRegistry.createEventConsumer(name, retryConfig.getEventConsumerBufferSize() != null ? retryConfig.getEventConsumerBufferSize() : 100));
                }
            });
            return retryRegistry;
        }
    }

    private static class RateLimiterRegistryProvider
    implements Provider<RateLimiterRegistry> {
        private Resilience4jConfig resilience4jConfig;
        private EventConsumerRegistry<RateLimiterEvent> eventConsumerRegistry;

        @Inject
        public RateLimiterRegistryProvider(Resilience4jConfig resilience4jConfig, EventConsumerRegistry<RateLimiterEvent> eventConsumerRegistry) {
            this.resilience4jConfig = resilience4jConfig;
            this.eventConsumerRegistry = eventConsumerRegistry;
        }

        public RateLimiterRegistry get() {
            RateLimiterConfigurationProperties rateLimiterProperties = this.resilience4jConfig.getRatelimiter();
            Map<String, RateLimiterConfig> configs = rateLimiterProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> rateLimiterProperties.createRateLimiterConfig((RateLimiterConfigurationProperties.InstanceProperties)entry.getValue(), new CompositeCustomizer(Collections.emptyList()), (String)entry.getKey())));
            RateLimiterRegistry rateLimiterRegistry = RateLimiterRegistry.of(configs);
            EndpointsConfig endpointsConfig = this.resilience4jConfig.getEndpoints();
            rateLimiterProperties.getInstances().forEach((name, rateLimiterConfig) -> {
                RateLimiter rateLimiter = rateLimiterRegistry.rateLimiter(name, rateLimiterProperties.createRateLimiterConfig(rateLimiterConfig, new CompositeCustomizer(Collections.emptyList()), name));
                if (endpointsConfig.getRatelimiter().isEnabled()) {
                    rateLimiter.getEventPublisher().onEvent((EventConsumer)this.eventConsumerRegistry.createEventConsumer(name, rateLimiterConfig.getEventConsumerBufferSize() != null ? rateLimiterConfig.getEventConsumerBufferSize() : 100));
                }
            });
            return rateLimiterRegistry;
        }
    }

    private static class CircuitBreakerRegistryProvider
    implements Provider<CircuitBreakerRegistry> {
        private Resilience4jConfig resilience4jConfig;
        private EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry;

        @Inject
        public CircuitBreakerRegistryProvider(Resilience4jConfig resilience4jConfig, EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry) {
            this.resilience4jConfig = resilience4jConfig;
            this.eventConsumerRegistry = eventConsumerRegistry;
        }

        public CircuitBreakerRegistry get() {
            CircuitBreakerConfigurationProperties circuitBreakerProperties = this.resilience4jConfig.getCircuitbreaker();
            Map<String, CircuitBreakerConfig> configs = circuitBreakerProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> circuitBreakerProperties.createCircuitBreakerConfig((String)entry.getKey(), (CircuitBreakerConfigurationProperties.InstanceProperties)entry.getValue(), new CompositeCustomizer(Collections.emptyList()))));
            CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.of(configs);
            EndpointsConfig endpointsConfig = this.resilience4jConfig.getEndpoints();
            circuitBreakerProperties.getInstances().forEach((name, circuitBreakerConfig) -> {
                io.github.resilience4j.circuitbreaker.CircuitBreaker circuitBreaker = circuitBreakerRegistry.circuitBreaker(name, circuitBreakerProperties.createCircuitBreakerConfig(name, circuitBreakerConfig, new CompositeCustomizer(Collections.emptyList())));
                if (endpointsConfig.getCircuitbreaker().isEnabled()) {
                    circuitBreaker.getEventPublisher().onEvent((EventConsumer)this.eventConsumerRegistry.createEventConsumer(name, circuitBreakerConfig.getEventConsumerBufferSize() != null ? circuitBreakerConfig.getEventConsumerBufferSize() : 100));
                }
            });
            return circuitBreakerRegistry;
        }
    }
}

