/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack;

import io.github.resilience4j.common.bulkhead.configuration.BulkheadConfigurationProperties;
import io.github.resilience4j.common.bulkhead.configuration.ThreadPoolBulkheadConfigurationProperties;
import io.github.resilience4j.common.circuitbreaker.configuration.CircuitBreakerConfigurationProperties;
import io.github.resilience4j.common.ratelimiter.configuration.RateLimiterConfigurationProperties;
import io.github.resilience4j.common.retry.configuration.RetryConfigurationProperties;
import io.github.resilience4j.common.timelimiter.configuration.TimeLimiterConfigurationProperties;
import io.github.resilience4j.ratpack.EndpointsConfig;
import ratpack.func.Function;
import ratpack.util.Exceptions;

public class Resilience4jConfig {
    private BulkheadConfigurationProperties bulkhead = new BulkheadConfigurationProperties();
    private ThreadPoolBulkheadConfigurationProperties threadpoolbulkhead = new ThreadPoolBulkheadConfigurationProperties();
    private CircuitBreakerConfigurationProperties circuitbreaker = new CircuitBreakerConfigurationProperties();
    private RateLimiterConfigurationProperties ratelimiter = new RateLimiterConfigurationProperties();
    private RetryConfigurationProperties retry = new RetryConfigurationProperties();
    private TimeLimiterConfigurationProperties timeLimiter = new TimeLimiterConfigurationProperties();
    private boolean metrics = false;
    private boolean prometheus = false;
    private EndpointsConfig endpoints = new EndpointsConfig();

    public Resilience4jConfig circuitBreaker(String name) {
        return this.circuitBreaker(name, (Function<? super CircuitBreakerConfigurationProperties.InstanceProperties, ? extends CircuitBreakerConfigurationProperties.InstanceProperties>)((Function)config -> config));
    }

    public Resilience4jConfig circuitBreaker(String name, Function<? super CircuitBreakerConfigurationProperties.InstanceProperties, ? extends CircuitBreakerConfigurationProperties.InstanceProperties> configure) {
        try {
            CircuitBreakerConfigurationProperties.InstanceProperties finalConfig = (CircuitBreakerConfigurationProperties.InstanceProperties)configure.apply((Object)new CircuitBreakerConfigurationProperties.InstanceProperties());
            this.circuitbreaker.getInstances().put(name, finalConfig);
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public Resilience4jConfig rateLimiter(String name) {
        return this.rateLimiter(name, (Function<? super RateLimiterConfigurationProperties.InstanceProperties, ? extends RateLimiterConfigurationProperties.InstanceProperties>)((Function)config -> config));
    }

    public Resilience4jConfig rateLimiter(String name, Function<? super RateLimiterConfigurationProperties.InstanceProperties, ? extends RateLimiterConfigurationProperties.InstanceProperties> configure) {
        try {
            RateLimiterConfigurationProperties.InstanceProperties finalConfig = (RateLimiterConfigurationProperties.InstanceProperties)configure.apply((Object)new RateLimiterConfigurationProperties.InstanceProperties());
            this.ratelimiter.getInstances().put(name, finalConfig);
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public Resilience4jConfig retry(String name) {
        return this.retry(name, (Function<? super RetryConfigurationProperties.InstanceProperties, ? extends RetryConfigurationProperties.InstanceProperties>)((Function)config -> config));
    }

    public Resilience4jConfig retry(String name, Function<? super RetryConfigurationProperties.InstanceProperties, ? extends RetryConfigurationProperties.InstanceProperties> configure) {
        try {
            RetryConfigurationProperties.InstanceProperties finalConfig = (RetryConfigurationProperties.InstanceProperties)configure.apply((Object)new RetryConfigurationProperties.InstanceProperties());
            this.retry.getInstances().put(name, finalConfig);
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public Resilience4jConfig bulkhead(String name) {
        return this.bulkhead(name, (Function<? super BulkheadConfigurationProperties.InstanceProperties, ? extends BulkheadConfigurationProperties.InstanceProperties>)((Function)config -> config));
    }

    public Resilience4jConfig bulkhead(String name, Function<? super BulkheadConfigurationProperties.InstanceProperties, ? extends BulkheadConfigurationProperties.InstanceProperties> configure) {
        try {
            BulkheadConfigurationProperties.InstanceProperties finalConfig = (BulkheadConfigurationProperties.InstanceProperties)configure.apply((Object)new BulkheadConfigurationProperties.InstanceProperties());
            this.bulkhead.getInstances().put(name, finalConfig);
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public Resilience4jConfig threadPoolBulkhead(String name) {
        return this.threadPoolBulkhead(name, (Function<? super ThreadPoolBulkheadConfigurationProperties.InstanceProperties, ? extends ThreadPoolBulkheadConfigurationProperties.InstanceProperties>)((Function)config -> config));
    }

    public Resilience4jConfig threadPoolBulkhead(String name, Function<? super ThreadPoolBulkheadConfigurationProperties.InstanceProperties, ? extends ThreadPoolBulkheadConfigurationProperties.InstanceProperties> configure) {
        try {
            ThreadPoolBulkheadConfigurationProperties.InstanceProperties finalConfig = (ThreadPoolBulkheadConfigurationProperties.InstanceProperties)configure.apply((Object)new ThreadPoolBulkheadConfigurationProperties.InstanceProperties());
            this.threadpoolbulkhead.getInstances().put(name, finalConfig);
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public Resilience4jConfig timeLimiter(String name) {
        return this.timeLimiter(name, (Function<? super TimeLimiterConfigurationProperties.InstanceProperties, ? extends TimeLimiterConfigurationProperties.InstanceProperties>)((Function)config -> config));
    }

    public Resilience4jConfig timeLimiter(String name, Function<? super TimeLimiterConfigurationProperties.InstanceProperties, ? extends TimeLimiterConfigurationProperties.InstanceProperties> configure) {
        try {
            TimeLimiterConfigurationProperties.InstanceProperties finalConfig = (TimeLimiterConfigurationProperties.InstanceProperties)configure.apply((Object)new TimeLimiterConfigurationProperties.InstanceProperties());
            this.timeLimiter.getInstances().put(name, finalConfig);
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public Resilience4jConfig metrics(boolean metrics) {
        this.metrics = metrics;
        return this;
    }

    public Resilience4jConfig prometheus(boolean prometheus) {
        this.prometheus = prometheus;
        return this;
    }

    public Resilience4jConfig endpoints(Function<? super EndpointsConfig, ? extends EndpointsConfig> configure) {
        try {
            this.endpoints = (EndpointsConfig)configure.apply((Object)new EndpointsConfig());
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public CircuitBreakerConfigurationProperties getCircuitbreaker() {
        return this.circuitbreaker;
    }

    public RateLimiterConfigurationProperties getRatelimiter() {
        return this.ratelimiter;
    }

    public RetryConfigurationProperties getRetry() {
        return this.retry;
    }

    public BulkheadConfigurationProperties getBulkhead() {
        return this.bulkhead;
    }

    public ThreadPoolBulkheadConfigurationProperties getThreadpoolbulkhead() {
        return this.threadpoolbulkhead;
    }

    public TimeLimiterConfigurationProperties getTimeLimiter() {
        return this.timeLimiter;
    }

    public boolean isMetrics() {
        return this.metrics;
    }

    public boolean isPrometheus() {
        return this.prometheus;
    }

    public EndpointsConfig getEndpoints() {
        return this.endpoints;
    }
}

