/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.internal;

import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.internal.AtomicRateLimiter;
import io.vavr.collection.Array;
import io.vavr.collection.Seq;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class InMemoryRateLimiterRegistry
extends AbstractRegistry<RateLimiter, RateLimiterConfig>
implements RateLimiterRegistry {
    public InMemoryRateLimiterRegistry() {
        this(RateLimiterConfig.ofDefaults());
    }

    public InMemoryRateLimiterRegistry(Map<String, RateLimiterConfig> configs) {
        this(configs.getOrDefault("default", RateLimiterConfig.ofDefaults()));
        this.configurations.putAll(configs);
    }

    public InMemoryRateLimiterRegistry(Map<String, RateLimiterConfig> configs, RegistryEventConsumer<RateLimiter> registryEventConsumer) {
        this(configs.getOrDefault("default", RateLimiterConfig.ofDefaults()), registryEventConsumer);
        this.configurations.putAll(configs);
    }

    public InMemoryRateLimiterRegistry(Map<String, RateLimiterConfig> configs, List<RegistryEventConsumer<RateLimiter>> registryEventConsumers) {
        this(configs.getOrDefault("default", RateLimiterConfig.ofDefaults()), registryEventConsumers);
        this.configurations.putAll(configs);
    }

    public InMemoryRateLimiterRegistry(RateLimiterConfig defaultConfig) {
        super((Object)defaultConfig);
    }

    public InMemoryRateLimiterRegistry(RateLimiterConfig defaultConfig, RegistryEventConsumer<RateLimiter> registryEventConsumer) {
        super((Object)defaultConfig, registryEventConsumer);
    }

    public InMemoryRateLimiterRegistry(RateLimiterConfig defaultConfig, List<RegistryEventConsumer<RateLimiter>> registryEventConsumers) {
        super((Object)defaultConfig, registryEventConsumers);
    }

    @Override
    public Seq<RateLimiter> getAllRateLimiters() {
        return Array.ofAll(this.entryMap.values());
    }

    @Override
    public RateLimiter rateLimiter(String name) {
        return this.rateLimiter(name, (RateLimiterConfig)this.getDefaultConfig());
    }

    @Override
    public RateLimiter rateLimiter(String name, RateLimiterConfig config) {
        return (RateLimiter)this.computeIfAbsent(name, () -> new AtomicRateLimiter(name, Objects.requireNonNull(config, "Config must not be null")));
    }

    @Override
    public RateLimiter rateLimiter(String name, Supplier<RateLimiterConfig> rateLimiterConfigSupplier) {
        return (RateLimiter)this.computeIfAbsent(name, () -> new AtomicRateLimiter(name, (RateLimiterConfig)Objects.requireNonNull(Objects.requireNonNull(rateLimiterConfigSupplier, "Supplier must not be null").get(), "Config must not be null")));
    }

    @Override
    public RateLimiter rateLimiter(String name, String configName) {
        return (RateLimiter)this.computeIfAbsent(name, () -> RateLimiter.of(name, (RateLimiterConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName))));
    }
}

