/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.internal;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnFailureEvent;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnSuccessEvent;
import io.github.resilience4j.ratelimiter.internal.RateLimiterEventProcessor;
import io.vavr.control.Option;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class SemaphoreBasedRateLimiter
implements RateLimiter {
    private static final String NAME_MUST_NOT_BE_NULL = "Name must not be null";
    private static final String CONFIG_MUST_NOT_BE_NULL = "RateLimiterConfig must not be null";
    private final String name;
    private final RateLimiterConfig rateLimiterConfig;
    private final ScheduledExecutorService scheduler;
    private final Semaphore semaphore;
    private final SemaphoreBasedRateLimiterMetrics metrics;
    private final RateLimiterEventProcessor eventProcessor;

    public SemaphoreBasedRateLimiter(String name, RateLimiterConfig rateLimiterConfig) {
        this(name, rateLimiterConfig, null);
    }

    public SemaphoreBasedRateLimiter(String name, RateLimiterConfig rateLimiterConfig, ScheduledExecutorService scheduler) {
        this.name = Objects.requireNonNull(name, NAME_MUST_NOT_BE_NULL);
        this.rateLimiterConfig = Objects.requireNonNull(rateLimiterConfig, CONFIG_MUST_NOT_BE_NULL);
        this.scheduler = (ScheduledExecutorService)Option.of((Object)scheduler).getOrElse(this::configureScheduler);
        this.semaphore = new Semaphore(this.rateLimiterConfig.getLimitForPeriod(), true);
        this.metrics = new SemaphoreBasedRateLimiterMetrics();
        this.eventProcessor = new RateLimiterEventProcessor();
        this.scheduleLimitRefresh();
    }

    private ScheduledExecutorService configureScheduler() {
        ThreadFactory threadFactory = target -> {
            Thread thread = new Thread(target, "SchedulerForSemaphoreBasedRateLimiterImpl-" + this.name);
            thread.setDaemon(true);
            return thread;
        };
        return Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    private void scheduleLimitRefresh() {
        this.scheduler.scheduleAtFixedRate(this::refreshLimit, this.rateLimiterConfig.getLimitRefreshPeriod().toNanos(), this.rateLimiterConfig.getLimitRefreshPeriod().toNanos(), TimeUnit.NANOSECONDS);
    }

    void refreshLimit() {
        int permissionsToRelease = this.rateLimiterConfig.getLimitForPeriod() - this.semaphore.availablePermits();
        this.semaphore.release(permissionsToRelease);
    }

    @Override
    public boolean getPermission(Duration timeoutDuration) {
        try {
            boolean success = this.semaphore.tryAcquire(timeoutDuration.toNanos(), TimeUnit.NANOSECONDS);
            this.publishRateLimiterEvent(success);
            return success;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.publishRateLimiterEvent(false);
            return false;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RateLimiter.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public RateLimiter.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    @Override
    public RateLimiterConfig getRateLimiterConfig() {
        return this.rateLimiterConfig;
    }

    public String toString() {
        return "SemaphoreBasedRateLimiter{name='" + this.name + '\'' + ", rateLimiterConfig=" + this.rateLimiterConfig + '}';
    }

    private void publishRateLimiterEvent(boolean permissionAcquired) {
        if (!this.eventProcessor.hasConsumers()) {
            return;
        }
        if (permissionAcquired) {
            this.eventProcessor.consumeEvent(new RateLimiterOnSuccessEvent(this.name));
            return;
        }
        this.eventProcessor.consumeEvent(new RateLimiterOnFailureEvent(this.name));
    }

    private final class SemaphoreBasedRateLimiterMetrics
    implements RateLimiter.Metrics {
        private SemaphoreBasedRateLimiterMetrics() {
        }

        @Override
        public int getAvailablePermissions() {
            return SemaphoreBasedRateLimiter.this.semaphore.availablePermits();
        }

        @Override
        public int getNumberOfWaitingThreads() {
            return SemaphoreBasedRateLimiter.this.semaphore.getQueueLength();
        }
    }
}

