/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter;

import java.time.Duration;
import java.util.Objects;

public class RateLimiterConfig {
    private static final String TIMEOUT_DURATION_MUST_NOT_BE_NULL = "TimeoutDuration must not be null";
    private static final String LIMIT_REFRESH_PERIOD_MUST_NOT_BE_NULL = "LimitRefreshPeriod must not be null";
    private static final Duration ACCEPTABLE_REFRESH_PERIOD = Duration.ofNanos(1L);
    private Duration timeoutDuration = Duration.ofSeconds(5L);
    private Duration limitRefreshPeriod = Duration.ofNanos(500L);
    private int limitForPeriod = 50;

    private RateLimiterConfig() {
    }

    public static Builder custom() {
        return new Builder();
    }

    public static RateLimiterConfig ofDefaults() {
        return new Builder().build();
    }

    public Duration getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public Duration getLimitRefreshPeriod() {
        return this.limitRefreshPeriod;
    }

    public int getLimitForPeriod() {
        return this.limitForPeriod;
    }

    public String toString() {
        return "RateLimiterConfig{timeoutDuration=" + this.timeoutDuration + ", limitRefreshPeriod=" + this.limitRefreshPeriod + ", limitForPeriod=" + this.limitForPeriod + '}';
    }

    private static Duration checkTimeoutDuration(Duration timeoutDuration) {
        return Objects.requireNonNull(timeoutDuration, TIMEOUT_DURATION_MUST_NOT_BE_NULL);
    }

    private static Duration checkLimitRefreshPeriod(Duration limitRefreshPeriod) {
        boolean refreshPeriodIsTooShort;
        Objects.requireNonNull(limitRefreshPeriod, LIMIT_REFRESH_PERIOD_MUST_NOT_BE_NULL);
        boolean bl = refreshPeriodIsTooShort = limitRefreshPeriod.compareTo(ACCEPTABLE_REFRESH_PERIOD) < 0;
        if (refreshPeriodIsTooShort) {
            throw new IllegalArgumentException("LimitRefreshPeriod is too short");
        }
        return limitRefreshPeriod;
    }

    private static int checkLimitForPeriod(int limitForPeriod) {
        if (limitForPeriod < 1) {
            throw new IllegalArgumentException("LimitForPeriod should be greater than 0");
        }
        return limitForPeriod;
    }

    public static class Builder {
        private RateLimiterConfig config = new RateLimiterConfig();

        public RateLimiterConfig build() {
            return this.config;
        }

        public Builder timeoutDuration(Duration timeoutDuration) {
            this.config.timeoutDuration = RateLimiterConfig.checkTimeoutDuration(timeoutDuration);
            return this;
        }

        public Builder limitRefreshPeriod(Duration limitRefreshPeriod) {
            this.config.limitRefreshPeriod = RateLimiterConfig.checkLimitRefreshPeriod(limitRefreshPeriod);
            return this;
        }

        public Builder limitForPeriod(int limitForPeriod) {
            this.config.limitForPeriod = RateLimiterConfig.checkLimitForPeriod(limitForPeriod);
            return this;
        }
    }
}

