/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.HashSet;
import java.util.Objects;

public class TaggedRetryMetrics
extends AbstractMetrics
implements MeterBinder {
    private final MetricNames names;
    private final RetryRegistry retryRegistry;

    public static TaggedRetryMetrics ofRetryRegistry(RetryRegistry retryRegistry) {
        return new TaggedRetryMetrics(MetricNames.ofDefaults(), retryRegistry);
    }

    public static TaggedRetryMetrics ofRetryRegistry(MetricNames names, RetryRegistry retryRegistry) {
        return new TaggedRetryMetrics(names, retryRegistry);
    }

    private TaggedRetryMetrics(MetricNames names, RetryRegistry retryRegistry) {
        this.names = Objects.requireNonNull(names);
        this.retryRegistry = Objects.requireNonNull(retryRegistry);
    }

    public void bindTo(MeterRegistry registry) {
        for (Retry retry : this.retryRegistry.getAllRetries()) {
            this.addMetrics(registry, retry);
        }
        this.retryRegistry.getEventPublisher().onEntryAdded(event -> this.addMetrics(registry, (Retry)event.getAddedEntry()));
        this.retryRegistry.getEventPublisher().onEntryRemoved(event -> this.removeMetrics(registry, ((Retry)event.getRemovedEntry()).getName()));
        this.retryRegistry.getEventPublisher().onEntryReplaced(event -> {
            this.removeMetrics(registry, ((Retry)event.getOldEntry()).getName());
            this.addMetrics(registry, (Retry)event.getNewEntry());
        });
    }

    private void addMetrics(MeterRegistry registry, Retry retry) {
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        idSet.add(Gauge.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfSuccessfulCallsWithoutRetryAttempt()).description("The number of successful calls without a retry attempt").tag("name", retry.getName()).tag("kind", "successful_without_retry").register(registry).getId());
        idSet.add(Gauge.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfSuccessfulCallsWithRetryAttempt()).description("The number of successful calls after a retry attempt").tag("name", retry.getName()).tag("kind", "successful_with_retry").register(registry).getId());
        idSet.add(Gauge.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfFailedCallsWithoutRetryAttempt()).description("The number of failed calls without a retry attempt").tag("name", retry.getName()).tag("kind", "failed_without_retry").register(registry).getId());
        idSet.add(Gauge.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfFailedCallsWithRetryAttempt()).description("The number of failed calls after a retry attempt").tag("name", retry.getName()).tag("kind", "failed_with_retry").register(registry).getId());
        this.meterIdMap.put(retry.getName(), idSet);
    }

    public static class MetricNames {
        public static final String DEFAULT_RETRY_CALLS = "resilience4j.retry.calls";
        private String callsMetricName = "resilience4j.retry.calls";

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        private MetricNames() {
        }

        public String getCallsMetricName() {
            return this.callsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder callsMetricName(String callsMetricName) {
                this.metricNames.callsMetricName = Objects.requireNonNull(callsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

