/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer;

import io.github.resilience4j.micrometer.MetricUtils;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;

public class RateLimiterMetrics
implements MeterBinder {
    private final Iterable<RateLimiter> rateLimiters;
    private final String prefix;

    private RateLimiterMetrics(Iterable<RateLimiter> rateLimiters) {
        this(rateLimiters, "resilience4j.ratelimiter");
    }

    private RateLimiterMetrics(Iterable<RateLimiter> rateLimiters, String prefix) {
        this.rateLimiters = Objects.requireNonNull(rateLimiters);
        this.prefix = Objects.requireNonNull(prefix);
    }

    public static RateLimiterMetrics ofRateLimiterRegistry(RateLimiterRegistry rateLimiterRegistry) {
        return new RateLimiterMetrics((Iterable<RateLimiter>)rateLimiterRegistry.getAllRateLimiters());
    }

    public void bindTo(MeterRegistry registry) {
        for (RateLimiter rateLimiter : this.rateLimiters) {
            String name = rateLimiter.getName();
            Gauge.builder((String)MetricUtils.getName(this.prefix, name, "available_permissions"), (Object)rateLimiter, cb -> cb.getMetrics().getAvailablePermissions()).register(registry);
            Gauge.builder((String)MetricUtils.getName(this.prefix, name, "number_of_waiting_threads"), (Object)rateLimiter, cb -> cb.getMetrics().getNumberOfWaitingThreads()).register(registry);
        }
    }
}

