/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.hedge.internal;

import io.github.resilience4j.core.ContextAwareScheduledThreadPoolExecutor;
import io.github.resilience4j.hedge.Hedge;
import io.github.resilience4j.hedge.HedgeConfig;
import io.github.resilience4j.hedge.event.HedgeEvent;
import io.github.resilience4j.hedge.event.HedgeOnPrimaryFailureEvent;
import io.github.resilience4j.hedge.event.HedgeOnPrimarySuccessEvent;
import io.github.resilience4j.hedge.event.HedgeOnSecondaryFailureEvent;
import io.github.resilience4j.hedge.event.HedgeOnSecondarySuccessEvent;
import io.github.resilience4j.hedge.internal.HedgeDurationSupplier;
import io.github.resilience4j.hedge.internal.HedgeEventProcessor;
import io.github.resilience4j.hedge.internal.HedgeResult;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HedgeImpl
implements Hedge {
    private static final Logger LOG = LoggerFactory.getLogger(HedgeImpl.class);
    private final String name;
    private final Map<String, String> tags;
    private final HedgeConfig hedgeConfig;
    private final HedgeEventProcessor eventProcessor;
    private final HedgeDurationSupplier durationSupplier;
    private final HedgeMetrics metrics;
    private final ContextAwareScheduledThreadPoolExecutor configuredHedgeExecutor;

    public HedgeImpl(String name, HedgeConfig hedgeConfig) {
        this(name, hedgeConfig, Collections.emptyMap());
    }

    public HedgeImpl(String name, HedgeConfig hedgeConfig, Map<String, String> tags) {
        this.name = name;
        this.tags = Objects.requireNonNull(tags, "Tags must not be null");
        this.hedgeConfig = hedgeConfig;
        this.eventProcessor = new HedgeEventProcessor();
        this.durationSupplier = HedgeDurationSupplier.fromConfig(hedgeConfig);
        this.metrics = new HedgeMetrics();
        this.configuredHedgeExecutor = ContextAwareScheduledThreadPoolExecutor.newScheduledThreadPool().corePoolSize(hedgeConfig.getConcurrentHedges()).contextPropagators(hedgeConfig.getContextPropagators()).build();
    }

    @Override
    public HedgeDurationSupplier getDurationSupplier() {
        return this.durationSupplier;
    }

    @Override
    public Duration getDuration() {
        return (Duration)this.durationSupplier.get();
    }

    private static <T> CompletableFuture<T> callableFuture(Callable<T> callable, ExecutorService executorService) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, executorService);
    }

    @Override
    public <T> CompletableFuture<T> submit(Callable<T> callable, ExecutorService primaryExecutor) {
        return this.decorateCaller(() -> HedgeImpl.callableFuture(callable, primaryExecutor), () -> HedgeImpl.callableFuture(callable, (ExecutorService)this.configuredHedgeExecutor)).get().toCompletableFuture();
    }

    @Override
    public <T, F extends CompletionStage<T>> Supplier<CompletionStage<T>> decorateCompletionStage(Supplier<F> supplier) {
        return this.decorateCaller(supplier, supplier);
    }

    private <T, F extends CompletionStage<T>> Supplier<CompletionStage<T>> decorateCaller(Supplier<F> primarySupplier, Supplier<F> hedgedSupplier) {
        return () -> {
            long start = System.nanoTime();
            CompletionStage supplied = ((CompletionStage)primarySupplier.get()).toCompletableFuture().handle((t, throwable) -> HedgeResult.of(t, true, Optional.ofNullable(throwable)));
            CompletableFuture timedCompletable = new CompletableFuture();
            CompletionStage hedged = ((CompletableFuture)timedCompletable.thenCompose(arg_0 -> HedgeImpl.lambda$decorateCaller$4((Supplier)hedgedSupplier, arg_0))).handle((t, throwable) -> HedgeResult.of(t, false, Optional.ofNullable(throwable)));
            ScheduledFuture sf = this.configuredHedgeExecutor.schedule(() -> timedCompletable.complete(null), ((Duration)this.durationSupplier.get()).toNanos(), TimeUnit.NANOSECONDS);
            return CompletableFuture.anyOf(new CompletableFuture[]{hedged, supplied}).thenApply(arg_0 -> this.lambda$decorateCaller$7(start, sf, (CompletableFuture)hedged, (CompletableFuture)supplied, arg_0));
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Hedge.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public HedgeConfig getHedgeConfig() {
        return this.hedgeConfig;
    }

    @Override
    public Hedge.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    @Override
    public void onPrimarySuccess(Duration duration) {
        this.metrics.primarySuccess.incrementAndGet();
        this.durationSupplier.accept(HedgeEvent.Type.PRIMARY_SUCCESS, duration);
        if (this.eventProcessor.hasConsumers()) {
            this.publishEvent(new HedgeOnPrimarySuccessEvent(this.name, duration));
        }
    }

    @Override
    public void onSecondarySuccess(Duration duration) {
        this.metrics.secondarySuccess.incrementAndGet();
        this.durationSupplier.accept(HedgeEvent.Type.SECONDARY_SUCCESS, duration);
        if (this.eventProcessor.hasConsumers()) {
            this.publishEvent(new HedgeOnSecondarySuccessEvent(this.name, duration));
        }
    }

    @Override
    public void onPrimaryFailure(Duration duration, Throwable throwable) {
        this.metrics.primaryFailure.incrementAndGet();
        this.durationSupplier.accept(HedgeEvent.Type.PRIMARY_FAILURE, duration);
        if (this.eventProcessor.hasConsumers()) {
            this.publishEvent(new HedgeOnPrimaryFailureEvent(this.name, duration, throwable));
        }
    }

    @Override
    public void onSecondaryFailure(Duration duration, Throwable throwable) {
        this.metrics.secondaryFailure.incrementAndGet();
        this.durationSupplier.accept(HedgeEvent.Type.SECONDARY_FAILURE, duration);
        if (this.eventProcessor.hasConsumers()) {
            this.publishEvent(new HedgeOnSecondaryFailureEvent(this.name, duration, throwable));
        }
    }

    private void publishEvent(HedgeEvent event) {
        try {
            this.eventProcessor.consumeEvent(event);
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to handle event {}", (Object)event.getEventType(), (Object)e);
        }
    }

    private /* synthetic */ Object lambda$decorateCaller$7(long start, ScheduledFuture sf, CompletableFuture hedged, CompletableFuture supplied, Object s) {
        HedgeResult t = (HedgeResult)s;
        long duration = System.nanoTime() - start;
        if (t.fromPrimary) {
            sf.cancel(true);
            hedged.cancel(false);
            if (t.throwable.isPresent()) {
                this.onPrimaryFailure(Duration.ofNanos(duration), t.throwable.get());
                throw (RuntimeException)t.throwable.get();
            }
            this.onPrimarySuccess(Duration.ofNanos(duration));
        } else {
            supplied.cancel(false);
            if (t.throwable.isPresent()) {
                this.onSecondaryFailure(Duration.ofNanos(duration), t.throwable.get());
                throw (RuntimeException)t.throwable.get();
            }
            this.onSecondarySuccess(Duration.ofNanos(duration));
        }
        return t.value;
    }

    private static /* synthetic */ CompletionStage lambda$decorateCaller$4(Supplier hedgedSupplier, Object t) {
        return (CompletionStage)hedgedSupplier.get();
    }

    private final class HedgeMetrics
    implements Hedge.Metrics {
        private AtomicLong primarySuccess = new AtomicLong(0L);
        private AtomicLong primaryFailure = new AtomicLong(0L);
        private AtomicLong secondarySuccess = new AtomicLong(0L);
        private AtomicLong secondaryFailure = new AtomicLong(0L);

        private HedgeMetrics() {
        }

        @Override
        public Duration getCurrentHedgeDelay() {
            return HedgeImpl.this.getDuration();
        }

        @Override
        public long getPrimarySuccessCount() {
            return this.primarySuccess.get();
        }

        @Override
        public long getSecondarySuccessCount() {
            return this.secondarySuccess.get();
        }

        @Override
        public long getPrimaryFailureCount() {
            return this.primaryFailure.get();
        }

        @Override
        public long getSecondaryFailureCount() {
            return this.secondaryFailure.get();
        }

        @Override
        public int getSecondaryPoolActiveCount() {
            return HedgeImpl.this.configuredHedgeExecutor.getActiveCount();
        }
    }
}

