/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.hedge;

import io.github.resilience4j.core.ClassUtils;
import io.github.resilience4j.core.ContextPropagator;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class HedgeConfig
implements Serializable {
    private static final long serialVersionUID = 2203981592465761602L;
    private static final String HEDGE_DURATION_MUST_NOT_BE_NULL = "HedgeDuration must not be null";
    private final int concurrentHedges;
    private final HedgeDurationSupplierType durationSupplierType;
    private final boolean shouldUseFactorAsPercentage;
    private final int hedgeTimeFactor;
    private final boolean shouldMeasureErrors;
    private final int windowSize;
    private final Duration cutoff;
    private final transient ContextPropagator[] contextPropagators;

    private HedgeConfig(int concurrentHedges, HedgeDurationSupplierType durationSupplierType, boolean shouldUseFactorAsPercentage, int hedgeTimeFactor, boolean shouldMeasureErrors, int windowSize, Duration cutoff, ContextPropagator[] propagators) {
        this.concurrentHedges = concurrentHedges;
        this.durationSupplierType = durationSupplierType;
        this.shouldUseFactorAsPercentage = shouldUseFactorAsPercentage;
        this.hedgeTimeFactor = hedgeTimeFactor;
        this.shouldMeasureErrors = shouldMeasureErrors;
        this.windowSize = windowSize;
        this.cutoff = cutoff;
        this.contextPropagators = propagators;
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder from(HedgeConfig baseConfig) {
        return new Builder(baseConfig);
    }

    public static HedgeConfig ofDefaults() {
        return new Builder().build();
    }

    public ContextPropagator[] getContextPropagators() {
        return this.contextPropagators;
    }

    public int getConcurrentHedges() {
        return this.concurrentHedges;
    }

    public String toString() {
        return "HedgeConfig{" + this.shouldUseFactorAsPercentage + "," + this.hedgeTimeFactor + "," + this.shouldMeasureErrors + "," + this.windowSize + "," + this.cutoff + "}";
    }

    public HedgeDurationSupplierType getDurationSupplier() {
        return this.durationSupplierType;
    }

    public boolean isShouldUseFactorAsPercentage() {
        return this.shouldUseFactorAsPercentage;
    }

    public int getHedgeTimeFactor() {
        return this.hedgeTimeFactor;
    }

    public boolean isShouldMeasureErrors() {
        return this.shouldMeasureErrors;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public Duration getCutoff() {
        return this.cutoff;
    }

    public static enum HedgeDurationSupplierType {
        PRECONFIGURED,
        AVERAGE_PLUS;

    }

    public static class Builder {
        private HedgeDurationSupplierType hedgeDurationSupplierType = HedgeDurationSupplierType.PRECONFIGURED;
        private boolean shouldUseFactorAsPercentage = false;
        private int hedgeTimeFactor = 0;
        private boolean shouldMeasureErrors = true;
        private int windowSize = 100;
        private Duration cutoff;
        private int concurrentHedges = 10;
        private Class<? extends ContextPropagator>[] contextPropagatorClasses = new Class[0];
        private List<? extends ContextPropagator> contextPropagators = new ArrayList<ContextPropagator>();

        public Builder() {
        }

        public Builder(HedgeConfig baseConfig) {
            this.shouldUseFactorAsPercentage = baseConfig.shouldUseFactorAsPercentage;
            this.hedgeTimeFactor = baseConfig.hedgeTimeFactor;
            this.shouldMeasureErrors = baseConfig.shouldMeasureErrors;
            this.windowSize = baseConfig.windowSize;
            this.cutoff = baseConfig.cutoff;
            this.concurrentHedges = baseConfig.concurrentHedges;
        }

        public static Builder fromConfig(HedgeConfig baseConfig) {
            return new Builder(baseConfig);
        }

        public HedgeConfig build() {
            ArrayList<? extends ContextPropagator> propagators = new ArrayList<ContextPropagator>();
            if (this.contextPropagatorClasses.length > 0) {
                propagators.addAll(Arrays.stream(this.contextPropagatorClasses).map(ClassUtils::instantiateClassDefConstructor).collect(Collectors.toList()));
            }
            if (!this.contextPropagators.isEmpty()) {
                propagators.addAll(this.contextPropagators);
            }
            ContextPropagator[] propArray = new ContextPropagator[propagators.size()];
            propagators.toArray(propArray);
            return new HedgeConfig(this.concurrentHedges, this.hedgeDurationSupplierType, this.shouldUseFactorAsPercentage, this.hedgeTimeFactor, this.shouldMeasureErrors, this.windowSize, this.cutoff, propArray);
        }

        public Builder averagePlusPercentageDuration(int percentageAsInteger, boolean shouldMeasureErrors) {
            this.hedgeDurationSupplierType = HedgeDurationSupplierType.AVERAGE_PLUS;
            this.shouldUseFactorAsPercentage = true;
            this.hedgeTimeFactor = percentageAsInteger;
            this.shouldMeasureErrors = shouldMeasureErrors;
            return this;
        }

        public Builder averagePlusAmountDuration(int amount, boolean shouldMeasureErrors, int windowSize) {
            this.hedgeDurationSupplierType = HedgeDurationSupplierType.AVERAGE_PLUS;
            this.shouldUseFactorAsPercentage = false;
            this.hedgeTimeFactor = amount;
            this.shouldMeasureErrors = shouldMeasureErrors;
            this.windowSize = windowSize;
            return this;
        }

        public Builder preconfiguredDuration(Duration cutoff) {
            if (cutoff == null) {
                throw new NullPointerException(HedgeConfig.HEDGE_DURATION_MUST_NOT_BE_NULL);
            }
            this.hedgeDurationSupplierType = HedgeDurationSupplierType.PRECONFIGURED;
            this.cutoff = cutoff;
            return this;
        }

        public final Builder withContextPropagators(Class<? extends ContextPropagator> ... contextPropagatorClasses) {
            this.contextPropagatorClasses = contextPropagatorClasses != null ? contextPropagatorClasses : new Class[]{};
            return this;
        }

        public final Builder withContextPropagators(ContextPropagator ... contextPropagators) {
            this.contextPropagators = contextPropagators != null ? Arrays.stream(contextPropagators).collect(Collectors.toList()) : new ArrayList<ContextPropagator>();
            return this;
        }

        public Builder withMaxConcurrency(int concurrentHedges) {
            this.concurrentHedges = concurrentHedges;
            return this;
        }
    }
}

