/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.retry.configuration;

import io.github.resilience4j.common.utils.ConfigUtils;
import io.github.resilience4j.core.ClassUtils;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.retry.IntervalFunction;
import io.github.resilience4j.retry.RetryConfig;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.time.DurationMin;

public class RetryConfigurationProperties {
    private final Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public RetryConfig createRetryConfig(String backend) {
        return this.createRetryConfig(this.getBackendProperties(backend));
    }

    @Nullable
    public InstanceProperties getBackendProperties(String backend) {
        return this.instances.get(backend);
    }

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getBackends() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    public RetryConfig createRetryConfig(InstanceProperties instanceProperties) {
        if (instanceProperties != null && StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            InstanceProperties baseProperties = this.configs.get(instanceProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(instanceProperties.getBaseConfig());
            }
            return this.buildConfigFromBaseConfig(baseProperties, instanceProperties);
        }
        return this.buildRetryConfig(RetryConfig.custom(), instanceProperties);
    }

    private RetryConfig buildConfigFromBaseConfig(InstanceProperties baseProperties, InstanceProperties instanceProperties) {
        RetryConfig baseConfig = this.buildRetryConfig(RetryConfig.custom(), baseProperties);
        ConfigUtils.mergePropertiesIfAny(baseProperties, instanceProperties);
        return this.buildRetryConfig(RetryConfig.from((RetryConfig)baseConfig), instanceProperties);
    }

    private RetryConfig buildRetryConfig(RetryConfig.Builder builder, InstanceProperties properties) {
        Predicate predicate;
        if (properties == null) {
            return builder.build();
        }
        if (properties.enableExponentialBackoff != null && properties.enableExponentialBackoff.booleanValue() && properties.enableRandomizedWait != null && properties.enableRandomizedWait.booleanValue()) {
            throw new IllegalStateException("you can not enable Exponential backoff policy and randomized delay at the same time , please enable only one of them");
        }
        this.configureRetryIntervalFunction(properties, (RetryConfig.Builder<Object>)builder);
        if (properties.getMaxRetryAttempts() != null && properties.getMaxRetryAttempts() != 0) {
            builder.maxAttempts(properties.getMaxRetryAttempts().intValue());
        }
        if (properties.getRetryExceptionPredicate() != null && properties.getRetryExceptionPredicate() != null && (predicate = ClassUtils.instantiatePredicateClass(properties.getRetryExceptionPredicate())) != null) {
            builder.retryOnException(predicate);
        }
        if (properties.getIgnoreExceptions() != null) {
            builder.ignoreExceptions((Class[])properties.getIgnoreExceptions());
        }
        if (properties.getRetryExceptions() != null) {
            builder.retryExceptions((Class[])properties.getRetryExceptions());
        }
        if (properties.getResultPredicate() != null && properties.getResultPredicate() != null && (predicate = ClassUtils.instantiatePredicateClass(properties.getResultPredicate())) != null) {
            builder.retryOnResult(predicate);
        }
        return builder.build();
    }

    private void configureRetryIntervalFunction(InstanceProperties properties, RetryConfig.Builder<Object> builder) {
        if (properties.getWaitDuration() != null && properties.getWaitDuration().toMillis() > 0L) {
            Duration waitDuration = properties.getWaitDuration();
            if (properties.getEnableExponentialBackoff() != null && properties.getEnableExponentialBackoff().booleanValue()) {
                if (properties.getExponentialBackoffMultiplier() != null) {
                    builder.intervalFunction(IntervalFunction.ofExponentialBackoff((long)waitDuration.toMillis(), (double)properties.getExponentialBackoffMultiplier()));
                } else {
                    builder.intervalFunction(IntervalFunction.ofExponentialBackoff((long)properties.getWaitDuration().toMillis()));
                }
            } else if (properties.getEnableRandomizedWait() != null && properties.getEnableRandomizedWait().booleanValue()) {
                if (properties.getRandomizedWaitFactor() != null) {
                    builder.intervalFunction(IntervalFunction.ofRandomized((long)waitDuration.toMillis(), (double)properties.getRandomizedWaitFactor()));
                } else {
                    builder.intervalFunction(IntervalFunction.ofRandomized((Duration)waitDuration));
                }
            } else {
                builder.waitDuration(Duration.ofMillis(properties.getWaitDuration().toMillis()));
            }
        }
    }

    public static class InstanceProperties {
        @DurationMin(millis=100L)
        @Nullable
        private @DurationMin(millis=100L) Duration waitDuration;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer maxRetryAttempts;
        @Nullable
        private Class<? extends Predicate<Throwable>> retryExceptionPredicate;
        @Nullable
        private Class<? extends Predicate<Object>> resultPredicate;
        @Nullable
        private Class<? extends Throwable>[] retryExceptions;
        @Nullable
        private Class<? extends Throwable>[] ignoreExceptions;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer eventConsumerBufferSize;
        @Nullable
        private Boolean enableExponentialBackoff;
        private Double exponentialBackoffMultiplier;
        @Nullable
        private Boolean enableRandomizedWait;
        private Double randomizedWaitFactor;
        @Nullable
        private String baseConfig;

        @Deprecated
        @Nullable
        public Long getWaitDurationMillis() {
            if (this.waitDuration != null) {
                return this.waitDuration.toMillis();
            }
            return null;
        }

        @Deprecated
        public InstanceProperties setWaitDurationMillis(Long waitDurationMillis) {
            this.waitDuration = Duration.ofMillis(waitDurationMillis);
            return this;
        }

        @Nullable
        public Duration getWaitDuration() {
            return this.waitDuration;
        }

        public InstanceProperties setWaitDuration(Duration waitDuration) {
            this.waitDuration = waitDuration;
            return this;
        }

        @Nullable
        public Integer getMaxRetryAttempts() {
            return this.maxRetryAttempts;
        }

        public InstanceProperties setMaxRetryAttempts(Integer maxRetryAttempts) {
            this.maxRetryAttempts = maxRetryAttempts;
            return this;
        }

        @Nullable
        public Class<? extends Predicate<Throwable>> getRetryExceptionPredicate() {
            return this.retryExceptionPredicate;
        }

        public InstanceProperties setRetryExceptionPredicate(Class<? extends Predicate<Throwable>> retryExceptionPredicate) {
            this.retryExceptionPredicate = retryExceptionPredicate;
            return this;
        }

        @Nullable
        public Class<? extends Predicate<Object>> getResultPredicate() {
            return this.resultPredicate;
        }

        public InstanceProperties setResultPredicate(Class<? extends Predicate<Object>> resultPredicate) {
            this.resultPredicate = resultPredicate;
            return this;
        }

        @Nullable
        public Class<? extends Throwable>[] getRetryExceptions() {
            return this.retryExceptions;
        }

        public InstanceProperties setRetryExceptions(Class<? extends Throwable>[] retryExceptions) {
            this.retryExceptions = retryExceptions;
            return this;
        }

        @Nullable
        public Class<? extends Throwable>[] getIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public InstanceProperties setIgnoreExceptions(Class<? extends Throwable>[] ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }

        public Boolean getEnableExponentialBackoff() {
            return this.enableExponentialBackoff;
        }

        public InstanceProperties setEnableExponentialBackoff(Boolean enableExponentialBackoff) {
            this.enableExponentialBackoff = enableExponentialBackoff;
            return this;
        }

        @Nullable
        public Double getExponentialBackoffMultiplier() {
            return this.exponentialBackoffMultiplier;
        }

        public InstanceProperties setExponentialBackoffMultiplier(Double exponentialBackoffMultiplier) {
            this.exponentialBackoffMultiplier = exponentialBackoffMultiplier;
            return this;
        }

        @Nullable
        public Boolean getEnableRandomizedWait() {
            return this.enableRandomizedWait;
        }

        public InstanceProperties setEnableRandomizedWait(Boolean enableRandomizedWait) {
            this.enableRandomizedWait = enableRandomizedWait;
            return this;
        }

        @Nullable
        public Double getRandomizedWaitFactor() {
            return this.randomizedWaitFactor;
        }

        public InstanceProperties setRandomizedWaitFactor(Double randomizedWaitFactor) {
            this.randomizedWaitFactor = randomizedWaitFactor;
            return this;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public InstanceProperties setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }
    }
}

