/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventPublisher;
import io.github.resilience4j.core.lang.Nullable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class EventProcessor<T>
implements EventPublisher<T> {
    protected volatile boolean consumerRegistered;
    @Nullable
    private volatile EventConsumer<T> onEventConsumer;
    private ConcurrentMap<Class<? extends T>, EventConsumer<Object>> eventConsumers = new ConcurrentHashMap<Class<? extends T>, EventConsumer<Object>>();

    public boolean hasConsumers() {
        return this.consumerRegistered;
    }

    public <E extends T> void registerConsumer(Class<? extends E> eventType, EventConsumer<E> eventConsumer) {
        this.consumerRegistered = true;
        this.eventConsumers.put(eventType, eventConsumer);
    }

    public <E extends T> boolean processEvent(E event) {
        EventConsumer eventConsumer;
        boolean consumed = false;
        EventConsumer<E> onEventConsumer = this.onEventConsumer;
        if (onEventConsumer != null) {
            onEventConsumer.consumeEvent(event);
            consumed = true;
        }
        if (!this.eventConsumers.isEmpty() && (eventConsumer = (EventConsumer)this.eventConsumers.get(event.getClass())) != null) {
            eventConsumer.consumeEvent(event);
            consumed = true;
        }
        return consumed;
    }

    @Override
    public void onEvent(@Nullable EventConsumer<T> onEventConsumer) {
        this.consumerRegistered = true;
        this.onEventConsumer = onEventConsumer;
    }
}

