/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerMetrics;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerState;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerStateMachine;

final class HalfOpenState
extends CircuitBreakerState {
    private CircuitBreakerMetrics circuitBreakerMetrics;
    private final float failureRateThreshold;

    HalfOpenState(CircuitBreakerStateMachine stateMachine) {
        super(stateMachine);
        CircuitBreakerConfig circuitBreakerConfig = stateMachine.getCircuitBreakerConfig();
        this.circuitBreakerMetrics = new CircuitBreakerMetrics(circuitBreakerConfig.getRingBufferSizeInHalfOpenState());
        this.failureRateThreshold = stateMachine.getCircuitBreakerConfig().getFailureRateThreshold();
    }

    @Override
    boolean isCallPermitted() {
        return true;
    }

    @Override
    void onError(Throwable throwable) {
        this.checkFailureRate(this.circuitBreakerMetrics.onError());
    }

    @Override
    void onSuccess() {
        this.checkFailureRate(this.circuitBreakerMetrics.onSuccess());
    }

    private void checkFailureRate(float currentFailureRate) {
        if (currentFailureRate != -1.0f) {
            if (currentFailureRate >= this.failureRateThreshold) {
                this.stateMachine.transitionToOpenState();
            } else {
                this.stateMachine.transitionToClosedState();
            }
        }
    }

    @Override
    CircuitBreaker.State getState() {
        return CircuitBreaker.State.HALF_OPEN;
    }

    @Override
    CircuitBreakerMetrics getMetrics() {
        return this.circuitBreakerMetrics;
    }
}

