/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker;

import java.time.Duration;
import java.util.function.Predicate;

public class CircuitBreakerConfig {
    public static final int DEFAULT_MAX_FAILURE_THRESHOLD = 50;
    public static final int DEFAULT_WAIT_DURATION_IN_OPEN_STATE = 60;
    public static final int DEFAULT_RING_BUFFER_SIZE_IN_HALF_OPEN_STATE = 10;
    public static final int DEFAULT_RING_BUFFER_SIZE_IN_CLOSED_STATE = 100;
    private float failureRateThreshold = 50.0f;
    private int ringBufferSizeInHalfOpenState = 10;
    private int ringBufferSizeInClosedState = 100;
    private Duration waitDurationInOpenState = Duration.ofSeconds(60L);
    private Predicate<? super Throwable> recordFailurePredicate = exception -> true;

    private CircuitBreakerConfig() {
    }

    public float getFailureRateThreshold() {
        return this.failureRateThreshold;
    }

    public Duration getWaitDurationInOpenState() {
        return this.waitDurationInOpenState;
    }

    public int getRingBufferSizeInHalfOpenState() {
        return this.ringBufferSizeInHalfOpenState;
    }

    public int getRingBufferSizeInClosedState() {
        return this.ringBufferSizeInClosedState;
    }

    public Predicate<? super Throwable> getRecordFailurePredicate() {
        return this.recordFailurePredicate;
    }

    public static Builder custom() {
        return new Builder();
    }

    public static CircuitBreakerConfig ofDefaults() {
        return new Builder().build();
    }

    public static class Builder {
        private CircuitBreakerConfig config = new CircuitBreakerConfig();

        public Builder failureRateThreshold(float failureRateThreshold) {
            if (failureRateThreshold <= 0.0f || failureRateThreshold > 100.0f) {
                throw new IllegalArgumentException("failureRateThreshold must be between 1 and 100");
            }
            this.config.failureRateThreshold = failureRateThreshold;
            return this;
        }

        public Builder waitDurationInOpenState(Duration waitDurationInOpenState) {
            if (waitDurationInOpenState.getSeconds() < 1L) {
                throw new IllegalArgumentException("waitDurationInOpenState must be at least 1000[ms]");
            }
            this.config.waitDurationInOpenState = waitDurationInOpenState;
            return this;
        }

        public Builder ringBufferSizeInHalfOpenState(int ringBufferSizeInHalfOpenState) {
            if (ringBufferSizeInHalfOpenState < 1) {
                throw new IllegalArgumentException("ringBufferSizeInHalfOpenState must be greater than 0");
            }
            this.config.ringBufferSizeInHalfOpenState = ringBufferSizeInHalfOpenState;
            return this;
        }

        public Builder ringBufferSizeInClosedState(int ringBufferSizeInClosedState) {
            if (ringBufferSizeInClosedState < 1) {
                throw new IllegalArgumentException("ringBufferSizeInClosedState must be greater than 0");
            }
            this.config.ringBufferSizeInClosedState = ringBufferSizeInClosedState;
            return this;
        }

        public Builder recordFailure(Predicate<? super Throwable> predicate) {
            this.config.recordFailurePredicate = predicate;
            return this;
        }

        public CircuitBreakerConfig build() {
            return this.config;
        }
    }
}

