/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.cache.internal;

import io.github.resilience4j.cache.Cache;
import io.github.resilience4j.cache.event.CacheEvent;
import io.github.resilience4j.cache.event.CacheOnErrorEvent;
import io.github.resilience4j.cache.event.CacheOnHitEvent;
import io.github.resilience4j.cache.event.CacheOnMissEvent;
import io.reactivex.Flowable;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.PublishProcessor;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheContext<K, V>
implements Cache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(CacheContext.class);
    private final javax.cache.Cache<K, V> cache;
    private final FlowableProcessor<CacheEvent> eventPublisher;
    private final CacheMetrics metrics;

    public CacheContext(javax.cache.Cache<K, V> cache) {
        this.cache = cache;
        PublishProcessor publisher = PublishProcessor.create();
        this.eventPublisher = publisher.toSerialized();
        this.metrics = new CacheMetrics();
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public Cache.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public V computeIfAbsent(K cacheKey, CheckedFunction0<V> supplier) {
        return (V)this.getValueFromCache(cacheKey).getOrElse(() -> this.computeAndPut(cacheKey, supplier));
    }

    private V computeAndPut(K cacheKey, CheckedFunction0<V> supplier) {
        return (V)Try.of(supplier).andThen(value -> this.putValueIntoCache(cacheKey, value)).get();
    }

    private Option<V> getValueFromCache(K cacheKey) {
        try {
            Option result = Option.of((Object)this.cache.get(cacheKey));
            if (result.isDefined()) {
                this.onCacheHit(cacheKey);
                return result;
            }
            this.onCacheMiss(cacheKey);
            return result;
        }
        catch (Exception exception) {
            LOG.warn(String.format("Failed to get a value from Cache %s", this.getName()), (Throwable)exception);
            this.onError(exception);
            return Option.none();
        }
    }

    private void putValueIntoCache(K cacheKey, V value) {
        try {
            if (value != null) {
                this.cache.put(cacheKey, value);
            }
        }
        catch (Exception exception) {
            LOG.warn(String.format("Failed to put a value into Cache %s", this.getName()), (Throwable)exception);
            this.onError(exception);
        }
    }

    private void onError(Throwable throwable) {
        this.publishCacheEvent(() -> new CacheOnErrorEvent(this.cache.getName(), throwable));
    }

    private void onCacheMiss(K cacheKey) {
        this.metrics.onCacheMiss();
        this.publishCacheEvent(() -> new CacheOnMissEvent<Object>(this.cache.getName(), cacheKey));
    }

    private void onCacheHit(K cacheKey) {
        this.metrics.onCacheHit();
        this.publishCacheEvent(() -> new CacheOnHitEvent<Object>(this.cache.getName(), cacheKey));
    }

    private void publishCacheEvent(Supplier<CacheEvent> event) {
        if (this.eventPublisher.hasSubscribers()) {
            this.eventPublisher.onNext((Object)event.get());
        }
    }

    @Override
    public Flowable<CacheEvent> getEventStream() {
        return this.eventPublisher;
    }

    private final class CacheMetrics
    implements Cache.Metrics {
        private final LongAdder cacheMisses = new LongAdder();
        private final LongAdder cacheHits = new LongAdder();

        private CacheMetrics() {
        }

        public void onCacheMiss() {
            this.cacheMisses.increment();
        }

        public void onCacheHit() {
            this.cacheHits.increment();
        }

        @Override
        public long getNumberOfCacheHits() {
            return this.cacheHits.longValue();
        }

        @Override
        public long getNumberOfCacheMisses() {
            return this.cacheMisses.longValue();
        }
    }
}

