/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.reactivex.FlowableOperator;
import io.reactivex.ObservableOperator;
import io.reactivex.Observer;
import io.reactivex.SingleObserver;
import io.reactivex.SingleOperator;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class BulkheadOperator<T>
implements ObservableOperator<T, T>,
FlowableOperator<T, T>,
SingleOperator<T, T> {
    private final Bulkhead bulkhead;

    private BulkheadOperator(Bulkhead bulkhead) {
        this.bulkhead = bulkhead;
    }

    public static <T> BulkheadOperator<T> of(Bulkhead bulkhead) {
        return new BulkheadOperator<T>(bulkhead);
    }

    public Subscriber<? super T> apply(Subscriber<? super T> childSubscriber) throws Exception {
        return new BulkheadSubscriber(childSubscriber);
    }

    public Observer<? super T> apply(Observer<? super T> childObserver) throws Exception {
        return new BulkheadObserver(childObserver);
    }

    public SingleObserver<? super T> apply(SingleObserver<? super T> childObserver) throws Exception {
        return new BulkheadSingleObserver(childObserver);
    }

    class BulkheadSingleObserver
    implements SingleObserver<T>,
    Disposable {
        private final SingleObserver<? super T> childObserver;
        private Disposable disposable;
        private AtomicBoolean cancelled = new AtomicBoolean(false);
        private volatile boolean rejected = false;

        BulkheadSingleObserver(SingleObserver<? super T> childObserver) {
            this.childObserver = childObserver;
        }

        public void onSubscribe(Disposable disposable) {
            this.disposable = disposable;
            if (BulkheadOperator.this.bulkhead.isCallPermitted()) {
                this.childObserver.onSubscribe((Disposable)this);
            } else {
                this.rejected = true;
                disposable.dispose();
                this.childObserver.onSubscribe((Disposable)this);
                this.childObserver.onError((Throwable)new BulkheadFullException(String.format("Bulkhead '%s' is full", BulkheadOperator.this.bulkhead.getName())));
            }
        }

        public void onError(Throwable e) {
            if (!this.isDisposed()) {
                BulkheadOperator.this.bulkhead.onComplete();
                this.childObserver.onError(e);
            }
        }

        public void onSuccess(T value) {
            if (!this.isDisposed()) {
                if (!this.rejected) {
                    BulkheadOperator.this.bulkhead.onComplete();
                }
                this.childObserver.onSuccess(value);
            }
        }

        public void dispose() {
            if (!this.cancelled.get()) {
                this.cancelled.set(true);
                BulkheadOperator.this.bulkhead.onComplete();
                this.disposable.dispose();
            }
        }

        public boolean isDisposed() {
            return this.cancelled.get();
        }
    }

    final class BulkheadObserver
    implements Observer<T>,
    Disposable {
        private final Observer<? super T> childObserver;
        private Disposable disposable;
        private AtomicBoolean cancelled = new AtomicBoolean(false);

        BulkheadObserver(Observer<? super T> childObserver) {
            this.childObserver = childObserver;
        }

        public void onSubscribe(Disposable disposable) {
            this.disposable = disposable;
            if (BulkheadOperator.this.bulkhead.isCallPermitted()) {
                this.childObserver.onSubscribe((Disposable)this);
            } else {
                disposable.dispose();
                this.childObserver.onSubscribe((Disposable)this);
                this.childObserver.onError((Throwable)new BulkheadFullException(String.format("Bulkhead '%s' is full", BulkheadOperator.this.bulkhead.getName())));
            }
        }

        public void onNext(T event) {
            if (!this.isDisposed()) {
                this.childObserver.onNext(event);
            }
        }

        public void onError(Throwable e) {
            if (!this.isDisposed()) {
                BulkheadOperator.this.bulkhead.onComplete();
                this.childObserver.onError(e);
            }
        }

        public void onComplete() {
            if (!this.isDisposed()) {
                BulkheadOperator.this.bulkhead.onComplete();
                this.childObserver.onComplete();
            }
        }

        public void dispose() {
            if (!this.cancelled.get()) {
                this.cancelled.set(true);
                BulkheadOperator.this.bulkhead.onComplete();
                this.disposable.dispose();
            }
        }

        public boolean isDisposed() {
            return this.cancelled.get();
        }
    }

    final class BulkheadSubscriber
    implements Subscriber<T>,
    Subscription {
        private final Subscriber<? super T> childSubscriber;
        private Subscription subscription;
        private AtomicBoolean cancelled = new AtomicBoolean(false);

        BulkheadSubscriber(Subscriber<? super T> childSubscriber) {
            this.childSubscriber = childSubscriber;
        }

        public void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            if (BulkheadOperator.this.bulkhead.isCallPermitted()) {
                this.childSubscriber.onSubscribe((Subscription)this);
            } else {
                subscription.cancel();
                this.childSubscriber.onSubscribe((Subscription)this);
                this.childSubscriber.onError((Throwable)new BulkheadFullException(String.format("Bulkhead '%s' is full", BulkheadOperator.this.bulkhead.getName())));
            }
        }

        public void onNext(T event) {
            if (!this.isCancelled()) {
                this.childSubscriber.onNext(event);
            }
        }

        public void onError(Throwable e) {
            if (!this.isCancelled()) {
                BulkheadOperator.this.bulkhead.onComplete();
                this.childSubscriber.onError(e);
            }
        }

        public void onComplete() {
            if (!this.isCancelled()) {
                BulkheadOperator.this.bulkhead.onComplete();
                this.childSubscriber.onComplete();
            }
        }

        public void request(long n) {
            this.subscription.request(n);
        }

        public void cancel() {
            if (!this.cancelled.get()) {
                this.cancelled.set(true);
                BulkheadOperator.this.bulkhead.onComplete();
                this.subscription.cancel();
            }
        }

        public boolean isCancelled() {
            return this.cancelled.get();
        }
    }
}

