/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.internal;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallPermittedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallRejectedEvent;
import io.reactivex.Flowable;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.PublishProcessor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class SemaphoreBulkhead
implements Bulkhead {
    private final String name;
    private final Semaphore semaphore;
    private final BulkheadConfig bulkheadConfig;
    private final FlowableProcessor<BulkheadEvent> eventPublisher;
    private final BulkheadMetrics metrics;

    public SemaphoreBulkhead(String name, BulkheadConfig bulkheadConfig) {
        this.name = name;
        this.bulkheadConfig = bulkheadConfig != null ? bulkheadConfig : BulkheadConfig.ofDefaults();
        this.semaphore = new Semaphore(this.bulkheadConfig.getMaxConcurrentCalls(), true);
        this.eventPublisher = PublishProcessor.create().toSerialized();
        this.metrics = new BulkheadMetrics();
    }

    public SemaphoreBulkhead(String name) {
        this(name, BulkheadConfig.ofDefaults());
    }

    public SemaphoreBulkhead(String name, Supplier<BulkheadConfig> configSupplier) {
        this(name, configSupplier.get());
    }

    @Override
    public boolean isCallPermitted() {
        boolean callPermitted = this.tryEnterBulkhead();
        this.publishBulkheadEvent(() -> callPermitted ? new BulkheadOnCallPermittedEvent(this.name) : new BulkheadOnCallRejectedEvent(this.name));
        return callPermitted;
    }

    @Override
    public void onComplete() {
        this.semaphore.release();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BulkheadConfig getBulkheadConfig() {
        return this.bulkheadConfig;
    }

    @Override
    public Bulkhead.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public Flowable<BulkheadEvent> getEventStream() {
        return this.eventPublisher;
    }

    public String toString() {
        return String.format("Bulkhead '%s'", this.name);
    }

    boolean tryEnterBulkhead() {
        boolean callPermitted = false;
        long timeout = this.bulkheadConfig.getMaxWaitTime();
        if (timeout == 0L) {
            callPermitted = this.semaphore.tryAcquire();
        } else {
            try {
                callPermitted = this.semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                callPermitted = false;
            }
        }
        return callPermitted;
    }

    private void publishBulkheadEvent(Supplier<BulkheadEvent> eventSupplier) {
        if (this.eventPublisher.hasSubscribers()) {
            this.eventPublisher.onNext((Object)eventSupplier.get());
        }
    }

    private final class BulkheadMetrics
    implements Bulkhead.Metrics {
        private BulkheadMetrics() {
        }

        @Override
        public int getAvailableConcurrentCalls() {
            return SemaphoreBulkhead.this.semaphore.availablePermits();
        }
    }
}

