/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallFinishedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallPermittedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallRejectedEvent;
import io.github.resilience4j.bulkhead.internal.FixedThreadPoolBulkhead;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventPublisher;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public interface ThreadPoolBulkhead {
    public static <T> Callable<CompletionStage<T>> decorateCallable(ThreadPoolBulkhead bulkhead, Callable<T> callable) {
        return () -> bulkhead.submit(callable);
    }

    public static <T> Supplier<CompletionStage<T>> decorateSupplier(ThreadPoolBulkhead bulkhead, Supplier<T> supplier) {
        return () -> bulkhead.submit(((Supplier)supplier)::get);
    }

    public static Runnable decorateRunnable(ThreadPoolBulkhead bulkhead, Runnable runnable) {
        return () -> bulkhead.submit(runnable);
    }

    public static ThreadPoolBulkhead ofDefaults(String name) {
        return new FixedThreadPoolBulkhead(name);
    }

    public static ThreadPoolBulkhead of(String name, ThreadPoolBulkheadConfig config) {
        return new FixedThreadPoolBulkhead(name, config);
    }

    public static ThreadPoolBulkhead of(String name, Supplier<ThreadPoolBulkheadConfig> bulkheadConfigSupplier) {
        return new FixedThreadPoolBulkhead(name, bulkheadConfigSupplier);
    }

    public <T> CompletionStage<T> submit(Callable<T> var1);

    public void submit(Runnable var1);

    public String getName();

    public ThreadPoolBulkheadConfig getBulkheadConfig();

    public Metrics getMetrics();

    public ThreadPoolBulkheadEventPublisher getEventPublisher();

    default public <T> CompletionStage<T> executeSupplier(Supplier<T> supplier) {
        return ThreadPoolBulkhead.decorateSupplier(this, supplier).get();
    }

    default public <T> CompletionStage<T> executeCallable(Callable<T> callable) throws Exception {
        return ThreadPoolBulkhead.decorateCallable(this, callable).call();
    }

    default public void executeRunnable(Runnable runnable) {
        ThreadPoolBulkhead.decorateRunnable(this, runnable).run();
    }

    public static interface ThreadPoolBulkheadEventPublisher
    extends EventPublisher<BulkheadEvent> {
        public ThreadPoolBulkheadEventPublisher onCallRejected(EventConsumer<BulkheadOnCallRejectedEvent> var1);

        public ThreadPoolBulkheadEventPublisher onCallPermitted(EventConsumer<BulkheadOnCallPermittedEvent> var1);

        public ThreadPoolBulkheadEventPublisher onCallFinished(EventConsumer<BulkheadOnCallFinishedEvent> var1);
    }

    public static interface Metrics {
        public int getCoreThreadPoolSize();

        public int getThreadPoolSize();

        public int getMaximumThreadPoolSize();

        public int getQueueDepth();

        public int getRemainingQueueCapacity();

        public int getQueueCapacity();
    }
}

