/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

public class ThreadPoolBulkheadConfig {
    public static final int DEFAULT_QUEUE_CAPACITY = 100;
    public static final long DEFAULT_KEEP_ALIVE_TIME = 20L;
    public static final int DEFAULT_CORE_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors() > 1 ? Runtime.getRuntime().availableProcessors() - 1 : 1;
    public static final int DEFAULT_MAX_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private int maxThreadPoolSize = DEFAULT_MAX_THREAD_POOL_SIZE;
    private int coreThreadPoolSize = DEFAULT_CORE_THREAD_POOL_SIZE;
    private int queueCapacity = 100;
    private long keepAliveTime = 20L;

    private ThreadPoolBulkheadConfig() {
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder from(ThreadPoolBulkheadConfig threadPoolBulkheadConfig) {
        return new Builder(threadPoolBulkheadConfig);
    }

    public static ThreadPoolBulkheadConfig ofDefaults() {
        return new Builder().build();
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public int getCoreThreadPoolSize() {
        return this.coreThreadPoolSize;
    }

    public static class Builder {
        private ThreadPoolBulkheadConfig config;

        public Builder(ThreadPoolBulkheadConfig bulkheadConfig) {
            this.config = bulkheadConfig;
        }

        public Builder() {
            this.config = new ThreadPoolBulkheadConfig();
        }

        public Builder maxThreadPoolSize(int maxThreadPoolSize) {
            if (maxThreadPoolSize < 1) {
                throw new IllegalArgumentException("maxThreadPoolSize must be a positive integer value >= 1");
            }
            this.config.maxThreadPoolSize = maxThreadPoolSize;
            return this;
        }

        public Builder coreThreadPoolSize(int coreThreadPoolSize) {
            if (coreThreadPoolSize < 1) {
                throw new IllegalArgumentException("coreThreadPoolSize must be a positive integer value >= 1");
            }
            this.config.coreThreadPoolSize = coreThreadPoolSize;
            return this;
        }

        public Builder queueCapacity(int queueCapacity) {
            if (queueCapacity < 1) {
                throw new IllegalArgumentException("queueCapacity must be a positive integer value >= 1");
            }
            this.config.queueCapacity = queueCapacity;
            return this;
        }

        public Builder keepAliveTime(long keepAliveTime) {
            if (keepAliveTime < 0L) {
                throw new IllegalArgumentException("keepAliveTime must be a positive integer value >= 0");
            }
            this.config.keepAliveTime = keepAliveTime;
            return this;
        }

        public ThreadPoolBulkheadConfig build() {
            if (this.config.maxThreadPoolSize < this.config.coreThreadPoolSize) {
                throw new IllegalArgumentException("maxThreadPoolSize must be a greater than or equals to coreThreadPoolSize");
            }
            return this.config;
        }
    }
}

