/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

import java.time.Duration;

public class BulkheadConfig {
    public static final int DEFAULT_MAX_CONCURRENT_CALLS = 25;
    public static final long DEFAULT_MAX_WAIT_TIME = 0L;
    private int maxConcurrentCalls = 25;
    private long maxWaitTime = 0L;

    private BulkheadConfig() {
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder from(BulkheadConfig baseConfig) {
        return new Builder(baseConfig);
    }

    public static BulkheadConfig ofDefaults() {
        return new Builder().build();
    }

    public int getMaxConcurrentCalls() {
        return this.maxConcurrentCalls;
    }

    public long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public static class Builder {
        private BulkheadConfig config = new BulkheadConfig();

        public Builder() {
        }

        public Builder(BulkheadConfig bulkheadConfig) {
            this.config = bulkheadConfig;
        }

        public Builder maxConcurrentCalls(int maxConcurrentCalls) {
            if (maxConcurrentCalls < 0) {
                throw new IllegalArgumentException("maxConcurrentCalls must be an integer value >= 0");
            }
            this.config.maxConcurrentCalls = maxConcurrentCalls;
            return this;
        }

        @Deprecated
        public Builder maxWaitTime(long maxWaitTime) {
            if (maxWaitTime < 0L) {
                throw new IllegalArgumentException("maxWaitTime must be a positive integer value >= 0");
            }
            this.config.maxWaitTime = maxWaitTime;
            return this;
        }

        public Builder maxWaitTimeDuration(Duration maxWaitTime) {
            if (maxWaitTime.toMillis() < 0L) {
                throw new IllegalArgumentException("maxWaitTime must be a positive integer value >= 0");
            }
            this.config.maxWaitTime = maxWaitTime.toMillis();
            return this;
        }

        public BulkheadConfig build() {
            return this.config;
        }
    }
}

