/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util.log;

import android.view.MotionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

class LogPrinterParser {
    LogPrinterParser() {
    }

    static String parseContent(Object ... obj) {
        StringBuilder buffer = new StringBuilder();
        if (obj != null) {
            if (obj.length > 1) {
                buffer.append(" {  ");
            }
            int i = 0;
            for (Object o : obj) {
                buffer.append("params\u3010").append(i).append("\u3011").append(" = ").append(LogPrinterParser.parseContentInternal(o));
                if (i < obj.length - 1) {
                    buffer.append(" , ");
                }
                ++i;
            }
            if (obj.length > 1) {
                buffer.append("  }");
            }
        }
        return buffer.toString();
    }

    private static String parseContentInternal(Object obj) {
        String result = null;
        result = obj instanceof String ? (String)obj : (obj instanceof Throwable ? LogPrinterParser.fromThrowable((Throwable)obj) : (obj instanceof List ? LogPrinterParser.fromList((List)obj) : (obj instanceof Map ? LogPrinterParser.fromMap((Map)obj) : (obj instanceof MotionEvent ? LogPrinterParser.fromMotionEvent((MotionEvent)obj) : String.valueOf(obj)))));
        return result;
    }

    private static String fromMotionEvent(MotionEvent motionEvent) {
        return LogPrinterParser.actionToString(motionEvent.getAction());
    }

    public static String actionToString(int action) {
        switch (action) {
            case 0: {
                return "ACTION_DOWN";
            }
            case 1: {
                return "ACTION_UP";
            }
            case 3: {
                return "ACTION_CANCEL";
            }
            case 4: {
                return "ACTION_OUTSIDE";
            }
            case 2: {
                return "ACTION_MOVE";
            }
            case 7: {
                return "ACTION_HOVER_MOVE";
            }
            case 8: {
                return "ACTION_SCROLL";
            }
            case 9: {
                return "ACTION_HOVER_ENTER";
            }
            case 10: {
                return "ACTION_HOVER_EXIT";
            }
            case 11: {
                return "ACTION_BUTTON_PRESS";
            }
            case 12: {
                return "ACTION_BUTTON_RELEASE";
            }
        }
        int index = (action & 0xFF00) >> 8;
        switch (action & 0xFF) {
            case 5: {
                return "ACTION_POINTER_DOWN(" + index + ")";
            }
            case 6: {
                return "ACTION_POINTER_UP(" + index + ")";
            }
        }
        return Integer.toString(action);
    }

    static String fromThrowable(Throwable tr) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        tr.printStackTrace(printWriter);
        for (Throwable cause = tr.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        String crashInfo = ((Object)writer).toString();
        printWriter.close();
        return crashInfo;
    }

    static String fromMap(Map map) {
        if (map == null) {
            return "map is null";
        }
        if (map.isEmpty()) {
            return "map is empty";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\n").append("{").append("\n").append("\t");
        for (Map.Entry entry : map.entrySet()) {
            builder.append(String.format("\t%1$s : %2$s", String.valueOf(entry.getKey()), String.valueOf(entry.getValue())));
            builder.append("\n");
        }
        builder.append("}");
        return builder.toString();
    }

    static String fromList(List list) {
        if (list == null) {
            return "list is null";
        }
        if (list.isEmpty()) {
            return "list is empty";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\n").append("{\n ");
        for (Object o : list) {
            if (o instanceof List) {
                builder.append(LogPrinterParser.fromList((List)o));
                continue;
            }
            builder.append(String.valueOf(o)).append(" ,\n ");
        }
        builder.append("}");
        return builder.toString();
    }
}

