/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Dialog;
import android.content.Context;
import android.view.View;
import androidx.fragment.app.Fragment;
import razerdp.basepopup.ClearMemoryObject;
import razerdp.basepopup.QuickPopupConfig;
import razerdp.library.R;
import razerdp.util.PopupUtils;
import razerdp.widget.QuickPopup;

public class QuickPopupBuilder
implements ClearMemoryObject {
    private static final String TAG = "QuickPopupBuilder";
    private QuickPopupConfig mConfig;
    private Object popupHost;
    private int width = 0;
    private int height = 0;

    private QuickPopupBuilder(Object obj) {
        this.popupHost = obj;
        this.mConfig = QuickPopupConfig.generateDefault();
    }

    public static QuickPopupBuilder with(Context context) {
        return new QuickPopupBuilder(context);
    }

    public static QuickPopupBuilder with(Fragment fragment) {
        return new QuickPopupBuilder(fragment);
    }

    public static QuickPopupBuilder with(Dialog dialog) {
        return new QuickPopupBuilder(dialog);
    }

    public QuickPopupBuilder contentView(int resId) {
        this.mConfig.contentViewLayoutid(resId);
        return this;
    }

    public QuickPopupBuilder width(int width) {
        this.width = width;
        return this;
    }

    public QuickPopupBuilder height(int height) {
        this.height = height;
        return this;
    }

    public final QuickPopupConfig getConfig() {
        return this.mConfig;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public QuickPopupBuilder config(QuickPopupConfig quickPopupConfig) {
        if (quickPopupConfig == null) {
            return this;
        }
        if (quickPopupConfig != this.mConfig) {
            quickPopupConfig.contentViewLayoutid(this.mConfig.contentViewLayoutid);
        }
        this.mConfig = quickPopupConfig;
        return this;
    }

    public QuickPopup build() {
        if (this.popupHost instanceof Context) {
            return new QuickPopup((Context)this.popupHost, this);
        }
        if (this.popupHost instanceof Fragment) {
            return new QuickPopup((Fragment)this.popupHost, this);
        }
        if (this.popupHost instanceof Dialog) {
            return new QuickPopup((Dialog)this.popupHost, this);
        }
        throw new NullPointerException(PopupUtils.getString(R.string.basepopup_host_destroyed, new Object[0]));
    }

    public QuickPopup show() {
        return this.show(null);
    }

    public QuickPopup show(View anchorView) {
        QuickPopup quickPopup = this.build();
        quickPopup.showPopupWindow(anchorView);
        return quickPopup;
    }

    public QuickPopup show(int x, int y) {
        QuickPopup quickPopup = this.build();
        quickPopup.showPopupWindow(x, y);
        return quickPopup;
    }

    @Override
    public void clear(boolean destroy) {
        this.popupHost = null;
        if (this.mConfig != null) {
            this.mConfig.clear(destroy);
        }
        this.mConfig = null;
    }
}

