/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.Exercise;
import org.quantlib.FixedVsFloatingSwap;
import org.quantlib.Option;
import org.quantlib.QuantLibJNI;
import org.quantlib.Settlement;
import org.quantlib.Swap;
import org.quantlib.VolatilityType;
import org.quantlib.YieldTermStructureHandle;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class Swaption
extends Option
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected Swaption(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.Swaption_SWIGSmartPtrUpcast(cPtr), true);
        this.swigCMemOwnDerived = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Swaption obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean own) {
        this.swigCMemOwnDerived = own;
        super.swigSetCMemOwn(own);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                QuantLibJNI.delete_Swaption(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Swaption(FixedVsFloatingSwap swap, Exercise exercise, Settlement.Type type, Settlement.Method settlementMethod) {
        this(QuantLibJNI.new_Swaption__SWIG_0(FixedVsFloatingSwap.getCPtr(swap), swap, Exercise.getCPtr(exercise), exercise, type.swigValue(), settlementMethod.swigValue()), true);
    }

    public Swaption(FixedVsFloatingSwap swap, Exercise exercise, Settlement.Type type) {
        this(QuantLibJNI.new_Swaption__SWIG_1(FixedVsFloatingSwap.getCPtr(swap), swap, Exercise.getCPtr(exercise), exercise, type.swigValue()), true);
    }

    public Swaption(FixedVsFloatingSwap swap, Exercise exercise) {
        this(QuantLibJNI.new_Swaption__SWIG_2(FixedVsFloatingSwap.getCPtr(swap), swap, Exercise.getCPtr(exercise), exercise), true);
    }

    public Settlement.Type settlementType() {
        return Settlement.Type.swigToEnum(QuantLibJNI.Swaption_settlementType(this.swigCPtr, this));
    }

    public Settlement.Method settlementMethod() {
        return Settlement.Method.swigToEnum(QuantLibJNI.Swaption_settlementMethod(this.swigCPtr, this));
    }

    public Swap.Type type() {
        return Swap.Type.swigToEnum(QuantLibJNI.Swaption_type(this.swigCPtr, this));
    }

    public FixedVsFloatingSwap underlying() {
        long cPtr = QuantLibJNI.Swaption_underlying(this.swigCPtr, this);
        return cPtr == 0L ? null : new FixedVsFloatingSwap(cPtr, true);
    }

    public double impliedVolatility(double price, YieldTermStructureHandle discountCurve, double guess, double accuracy, long maxEvaluations, double minVol, double maxVol, VolatilityType type, double displacement, PriceType priceType) {
        return QuantLibJNI.Swaption_impliedVolatility__SWIG_0(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve, guess, accuracy, maxEvaluations, minVol, maxVol, type.swigValue(), displacement, priceType.swigValue());
    }

    public double impliedVolatility(double price, YieldTermStructureHandle discountCurve, double guess, double accuracy, long maxEvaluations, double minVol, double maxVol, VolatilityType type, double displacement) {
        return QuantLibJNI.Swaption_impliedVolatility__SWIG_1(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve, guess, accuracy, maxEvaluations, minVol, maxVol, type.swigValue(), displacement);
    }

    public double impliedVolatility(double price, YieldTermStructureHandle discountCurve, double guess, double accuracy, long maxEvaluations, double minVol, double maxVol, VolatilityType type) {
        return QuantLibJNI.Swaption_impliedVolatility__SWIG_2(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve, guess, accuracy, maxEvaluations, minVol, maxVol, type.swigValue());
    }

    public double impliedVolatility(double price, YieldTermStructureHandle discountCurve, double guess, double accuracy, long maxEvaluations, double minVol, double maxVol) {
        return QuantLibJNI.Swaption_impliedVolatility__SWIG_3(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve, guess, accuracy, maxEvaluations, minVol, maxVol);
    }

    public double impliedVolatility(double price, YieldTermStructureHandle discountCurve, double guess, double accuracy, long maxEvaluations, double minVol) {
        return QuantLibJNI.Swaption_impliedVolatility__SWIG_4(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve, guess, accuracy, maxEvaluations, minVol);
    }

    public double impliedVolatility(double price, YieldTermStructureHandle discountCurve, double guess, double accuracy, long maxEvaluations) {
        return QuantLibJNI.Swaption_impliedVolatility__SWIG_5(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve, guess, accuracy, maxEvaluations);
    }

    public double impliedVolatility(double price, YieldTermStructureHandle discountCurve, double guess, double accuracy) {
        return QuantLibJNI.Swaption_impliedVolatility__SWIG_6(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve, guess, accuracy);
    }

    public double impliedVolatility(double price, YieldTermStructureHandle discountCurve, double guess) {
        return QuantLibJNI.Swaption_impliedVolatility__SWIG_7(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(discountCurve), discountCurve, guess);
    }

    public double vega() {
        return QuantLibJNI.Swaption_vega(this.swigCPtr, this);
    }

    public double delta() {
        return QuantLibJNI.Swaption_delta(this.swigCPtr, this);
    }

    public double annuity() {
        return QuantLibJNI.Swaption_annuity(this.swigCPtr, this);
    }

    public double forwardPrice() {
        return QuantLibJNI.Swaption_forwardPrice(this.swigCPtr, this);
    }

    public static final class PriceType {
        public static final PriceType Spot = new PriceType("Spot");
        public static final PriceType Forward = new PriceType("Forward");
        private static PriceType[] swigValues = new PriceType[]{Spot, Forward};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static PriceType swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && PriceType.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (PriceType.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(PriceType.class) + " with value " + swigValue);
        }

        private PriceType(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private PriceType(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private PriceType(String swigName, PriceType swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

