/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.quantlib.QuantLibJNI;
import org.quantlib.SwapIndex;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class SwapIndexVector
extends AbstractList<SwapIndex>
implements QuantLibJNIHelpers.AutoCloseable,
RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected SwapIndexVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(SwapIndexVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(SwapIndexVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_SwapIndexVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public SwapIndexVector(SwapIndex[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (SwapIndex element : initialElements) {
            this.add(element);
        }
    }

    public SwapIndexVector(Iterable<SwapIndex> initialElements) {
        this();
        for (SwapIndex element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public SwapIndex get(int index) {
        return this.doGet(index);
    }

    @Override
    public SwapIndex set(int index, SwapIndex e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(SwapIndex e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, SwapIndex e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public SwapIndex remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public SwapIndexVector() {
        this(QuantLibJNI.new_SwapIndexVector__SWIG_0(), true);
    }

    public SwapIndexVector(SwapIndexVector other) {
        this(QuantLibJNI.new_SwapIndexVector__SWIG_1(SwapIndexVector.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return QuantLibJNI.SwapIndexVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        QuantLibJNI.SwapIndexVector_clear(this.swigCPtr, this);
    }

    public SwapIndexVector(int count, SwapIndex value) {
        this(QuantLibJNI.new_SwapIndexVector__SWIG_2(count, SwapIndex.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return QuantLibJNI.SwapIndexVector_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        QuantLibJNI.SwapIndexVector_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return QuantLibJNI.SwapIndexVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(SwapIndex x) {
        QuantLibJNI.SwapIndexVector_doAdd__SWIG_0(this.swigCPtr, this, SwapIndex.getCPtr(x), x);
    }

    private void doAdd(int index, SwapIndex x) {
        QuantLibJNI.SwapIndexVector_doAdd__SWIG_1(this.swigCPtr, this, index, SwapIndex.getCPtr(x), x);
    }

    private SwapIndex doRemove(int index) {
        long cPtr = QuantLibJNI.SwapIndexVector_doRemove(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new SwapIndex(cPtr, true);
    }

    private SwapIndex doGet(int index) {
        long cPtr = QuantLibJNI.SwapIndexVector_doGet(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new SwapIndex(cPtr, true);
    }

    private SwapIndex doSet(int index, SwapIndex val) {
        long cPtr = QuantLibJNI.SwapIndexVector_doSet(this.swigCPtr, this, index, SwapIndex.getCPtr(val), val);
        return cPtr == 0L ? null : new SwapIndex(cPtr, true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        QuantLibJNI.SwapIndexVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

