/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.BoolVector;
import org.quantlib.Date;
import org.quantlib.Instrument;
import org.quantlib.Leg;
import org.quantlib.LegVector;
import org.quantlib.QuantLibJNI;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class Swap
extends Instrument
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected Swap(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.Swap_SWIGSmartPtrUpcast(cPtr), true);
        this.swigCMemOwnDerived = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Swap obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean own) {
        this.swigCMemOwnDerived = own;
        super.swigSetCMemOwn(own);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                QuantLibJNI.delete_Swap(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Swap(Leg firstLeg, Leg secondLeg) {
        this(QuantLibJNI.new_Swap__SWIG_0(Leg.getCPtr(firstLeg), firstLeg, Leg.getCPtr(secondLeg), secondLeg), true);
    }

    public Swap(LegVector legs, BoolVector payer) {
        this(QuantLibJNI.new_Swap__SWIG_1(LegVector.getCPtr(legs), legs, BoolVector.getCPtr(payer), payer), true);
    }

    public long numberOfLegs() {
        return QuantLibJNI.Swap_numberOfLegs(this.swigCPtr, this);
    }

    public Date startDate() {
        return new Date(QuantLibJNI.Swap_startDate(this.swigCPtr, this), true);
    }

    public Date maturityDate() {
        return new Date(QuantLibJNI.Swap_maturityDate(this.swigCPtr, this), true);
    }

    public Leg leg(long i) {
        return new Leg(QuantLibJNI.Swap_leg(this.swigCPtr, this, i), false);
    }

    public double legNPV(long j) {
        return QuantLibJNI.Swap_legNPV(this.swigCPtr, this, j);
    }

    public double legBPS(long k) {
        return QuantLibJNI.Swap_legBPS(this.swigCPtr, this, k);
    }

    public double startDiscounts(long j) {
        return QuantLibJNI.Swap_startDiscounts(this.swigCPtr, this, j);
    }

    public double endDiscounts(long j) {
        return QuantLibJNI.Swap_endDiscounts(this.swigCPtr, this, j);
    }

    public double npvDateDiscount() {
        return QuantLibJNI.Swap_npvDateDiscount(this.swigCPtr, this);
    }

    public boolean payer(long j) {
        return QuantLibJNI.Swap_payer(this.swigCPtr, this, j);
    }

    public static final class Type {
        public static final Type Receiver = new Type("Receiver", QuantLibJNI.Swap_Receiver_get());
        public static final Type Payer = new Type("Payer", QuantLibJNI.Swap_Payer_get());
        private static Type[] swigValues = new Type[]{Receiver, Payer};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static Type swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && Type.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (Type.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(Type.class) + " with value " + swigValue);
        }

        private Type(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private Type(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private Type(String swigName, Type swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

