/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.DoubleVector;
import org.quantlib.QuantLibJNI;
import org.quantlib.UnsignedIntVector;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class SparseMatrix
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    private transient boolean swigCMemOwn;

    protected SparseMatrix(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(SparseMatrix obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void swigSetCMemOwn(boolean own) {
        this.swigCMemOwn = own;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_SparseMatrix(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setRow_idx(UnsignedIntVector value) {
        QuantLibJNI.SparseMatrix_row_idx_set(this.swigCPtr, this, UnsignedIntVector.getCPtr(value), value);
    }

    public UnsignedIntVector getRow_idx() {
        long cPtr = QuantLibJNI.SparseMatrix_row_idx_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new UnsignedIntVector(cPtr, false);
    }

    public void setCol_idx(UnsignedIntVector value) {
        QuantLibJNI.SparseMatrix_col_idx_set(this.swigCPtr, this, UnsignedIntVector.getCPtr(value), value);
    }

    public UnsignedIntVector getCol_idx() {
        long cPtr = QuantLibJNI.SparseMatrix_col_idx_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new UnsignedIntVector(cPtr, false);
    }

    public void setData(DoubleVector value) {
        QuantLibJNI.SparseMatrix_data_set(this.swigCPtr, this, DoubleVector.getCPtr(value), value);
    }

    public DoubleVector getData() {
        long cPtr = QuantLibJNI.SparseMatrix_data_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new DoubleVector(cPtr, false);
    }

    public SparseMatrix() {
        this(QuantLibJNI.new_SparseMatrix(), true);
    }
}

