/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.QuantLibJNI;
import org.quantlib.Statistics;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class RiskStatistics
extends Statistics
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;

    protected RiskStatistics(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.RiskStatistics_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(RiskStatistics obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(RiskStatistics obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_RiskStatistics(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public double semiVariance() {
        return QuantLibJNI.RiskStatistics_semiVariance(this.swigCPtr, this);
    }

    public double semiDeviation() {
        return QuantLibJNI.RiskStatistics_semiDeviation(this.swigCPtr, this);
    }

    public double downsideVariance() {
        return QuantLibJNI.RiskStatistics_downsideVariance(this.swigCPtr, this);
    }

    public double downsideDeviation() {
        return QuantLibJNI.RiskStatistics_downsideDeviation(this.swigCPtr, this);
    }

    public double regret(double target) {
        return QuantLibJNI.RiskStatistics_regret(this.swigCPtr, this, target);
    }

    public double potentialUpside(double percentile) {
        return QuantLibJNI.RiskStatistics_potentialUpside(this.swigCPtr, this, percentile);
    }

    public double valueAtRisk(double percentile) {
        return QuantLibJNI.RiskStatistics_valueAtRisk(this.swigCPtr, this, percentile);
    }

    public double expectedShortfall(double percentile) {
        return QuantLibJNI.RiskStatistics_expectedShortfall(this.swigCPtr, this, percentile);
    }

    public double shortfall(double target) {
        return QuantLibJNI.RiskStatistics_shortfall(this.swigCPtr, this, target);
    }

    public double averageShortfall(double target) {
        return QuantLibJNI.RiskStatistics_averageShortfall(this.swigCPtr, this, target);
    }

    public RiskStatistics() {
        this(QuantLibJNI.new_RiskStatistics(), true);
    }
}

