/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.quantlib.QuantLibJNI;
import org.quantlib.QuoteVector;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class QuoteVectorVector
extends AbstractList<QuoteVector>
implements QuantLibJNIHelpers.AutoCloseable,
RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected QuoteVectorVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(QuoteVectorVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(QuoteVectorVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_QuoteVectorVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public QuoteVectorVector(QuoteVector[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (QuoteVector element : initialElements) {
            this.add(element);
        }
    }

    public QuoteVectorVector(Iterable<QuoteVector> initialElements) {
        this();
        for (QuoteVector element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public QuoteVector get(int index) {
        return this.doGet(index);
    }

    @Override
    public QuoteVector set(int index, QuoteVector e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(QuoteVector e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, QuoteVector e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public QuoteVector remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public QuoteVectorVector() {
        this(QuantLibJNI.new_QuoteVectorVector__SWIG_0(), true);
    }

    public QuoteVectorVector(QuoteVectorVector other) {
        this(QuantLibJNI.new_QuoteVectorVector__SWIG_1(QuoteVectorVector.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return QuantLibJNI.QuoteVectorVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        QuantLibJNI.QuoteVectorVector_clear(this.swigCPtr, this);
    }

    public QuoteVectorVector(int count, QuoteVector value) {
        this(QuantLibJNI.new_QuoteVectorVector__SWIG_2(count, QuoteVector.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return QuantLibJNI.QuoteVectorVector_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        QuantLibJNI.QuoteVectorVector_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return QuantLibJNI.QuoteVectorVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(QuoteVector x) {
        QuantLibJNI.QuoteVectorVector_doAdd__SWIG_0(this.swigCPtr, this, QuoteVector.getCPtr(x), x);
    }

    private void doAdd(int index, QuoteVector x) {
        QuantLibJNI.QuoteVectorVector_doAdd__SWIG_1(this.swigCPtr, this, index, QuoteVector.getCPtr(x), x);
    }

    private QuoteVector doRemove(int index) {
        return new QuoteVector(QuantLibJNI.QuoteVectorVector_doRemove(this.swigCPtr, this, index), true);
    }

    private QuoteVector doGet(int index) {
        return new QuoteVector(QuantLibJNI.QuoteVectorVector_doGet(this.swigCPtr, this, index), false);
    }

    private QuoteVector doSet(int index, QuoteVector val) {
        return new QuoteVector(QuantLibJNI.QuoteVectorVector_doSet(this.swigCPtr, this, index, QuoteVector.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        QuantLibJNI.QuoteVectorVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

