/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.quantlib.QuantLibJNI;
import org.quantlib.QuoteHandle;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class QuoteHandleVector
extends AbstractList<QuoteHandle>
implements QuantLibJNIHelpers.AutoCloseable,
RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected QuoteHandleVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(QuoteHandleVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(QuoteHandleVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_QuoteHandleVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public QuoteHandleVector(QuoteHandle[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (QuoteHandle element : initialElements) {
            this.add(element);
        }
    }

    public QuoteHandleVector(Iterable<QuoteHandle> initialElements) {
        this();
        for (QuoteHandle element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public QuoteHandle get(int index) {
        return this.doGet(index);
    }

    @Override
    public QuoteHandle set(int index, QuoteHandle e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(QuoteHandle e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, QuoteHandle e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public QuoteHandle remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public QuoteHandleVector() {
        this(QuantLibJNI.new_QuoteHandleVector__SWIG_0(), true);
    }

    public QuoteHandleVector(QuoteHandleVector other) {
        this(QuantLibJNI.new_QuoteHandleVector__SWIG_1(QuoteHandleVector.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return QuantLibJNI.QuoteHandleVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        QuantLibJNI.QuoteHandleVector_clear(this.swigCPtr, this);
    }

    public QuoteHandleVector(int count, QuoteHandle value) {
        this(QuantLibJNI.new_QuoteHandleVector__SWIG_2(count, QuoteHandle.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return QuantLibJNI.QuoteHandleVector_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        QuantLibJNI.QuoteHandleVector_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return QuantLibJNI.QuoteHandleVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(QuoteHandle x) {
        QuantLibJNI.QuoteHandleVector_doAdd__SWIG_0(this.swigCPtr, this, QuoteHandle.getCPtr(x), x);
    }

    private void doAdd(int index, QuoteHandle x) {
        QuantLibJNI.QuoteHandleVector_doAdd__SWIG_1(this.swigCPtr, this, index, QuoteHandle.getCPtr(x), x);
    }

    private QuoteHandle doRemove(int index) {
        return new QuoteHandle(QuantLibJNI.QuoteHandleVector_doRemove(this.swigCPtr, this, index), true);
    }

    private QuoteHandle doGet(int index) {
        return new QuoteHandle(QuantLibJNI.QuoteHandleVector_doGet(this.swigCPtr, this, index), false);
    }

    private QuoteHandle doSet(int index, QuoteHandle val) {
        return new QuoteHandle(QuantLibJNI.QuoteHandleVector_doSet(this.swigCPtr, this, index, QuoteHandle.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        QuantLibJNI.QuoteHandleVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

