/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.quantlib.NodePair;
import org.quantlib.QuantLibJNI;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class NodeVector
extends AbstractList<NodePair>
implements QuantLibJNIHelpers.AutoCloseable,
RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected NodeVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(NodeVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(NodeVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_NodeVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public NodeVector(NodePair[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (NodePair element : initialElements) {
            this.add(element);
        }
    }

    public NodeVector(Iterable<NodePair> initialElements) {
        this();
        for (NodePair element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public NodePair get(int index) {
        return this.doGet(index);
    }

    @Override
    public NodePair set(int index, NodePair e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(NodePair e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, NodePair e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public NodePair remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public NodeVector() {
        this(QuantLibJNI.new_NodeVector__SWIG_0(), true);
    }

    public NodeVector(NodeVector other) {
        this(QuantLibJNI.new_NodeVector__SWIG_1(NodeVector.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return QuantLibJNI.NodeVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        QuantLibJNI.NodeVector_clear(this.swigCPtr, this);
    }

    public NodeVector(int count, NodePair value) {
        this(QuantLibJNI.new_NodeVector__SWIG_2(count, NodePair.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return QuantLibJNI.NodeVector_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        QuantLibJNI.NodeVector_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return QuantLibJNI.NodeVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(NodePair x) {
        QuantLibJNI.NodeVector_doAdd__SWIG_0(this.swigCPtr, this, NodePair.getCPtr(x), x);
    }

    private void doAdd(int index, NodePair x) {
        QuantLibJNI.NodeVector_doAdd__SWIG_1(this.swigCPtr, this, index, NodePair.getCPtr(x), x);
    }

    private NodePair doRemove(int index) {
        return new NodePair(QuantLibJNI.NodeVector_doRemove(this.swigCPtr, this, index), true);
    }

    private NodePair doGet(int index) {
        return new NodePair(QuantLibJNI.NodeVector_doGet(this.swigCPtr, this, index), false);
    }

    private NodePair doSet(int index, NodePair val) {
        return new NodePair(QuantLibJNI.NodeVector_doSet(this.swigCPtr, this, index, NodePair.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        QuantLibJNI.NodeVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

