/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.Currency;
import org.quantlib.QuantLibJNI;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class Money
implements QuantLibJNIHelpers.AutoCloseable,
Comparable<Money> {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Money(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Money obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Money obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_Money(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public Money(Currency currency, double value) {
        this(QuantLibJNI.new_Money__SWIG_0(Currency.getCPtr(currency), currency, value), true);
    }

    public Money(double value, Currency currency) {
        this(QuantLibJNI.new_Money__SWIG_1(value, Currency.getCPtr(currency), currency), true);
    }

    public Currency currency() {
        return new Currency(QuantLibJNI.Money_currency(this.swigCPtr, this), false);
    }

    public double value() {
        return QuantLibJNI.Money_value(this.swigCPtr, this);
    }

    public Money rounded() {
        return new Money(QuantLibJNI.Money_rounded(this.swigCPtr, this), true);
    }

    public Money add() {
        return new Money(QuantLibJNI.Money_add__SWIG_0(this.swigCPtr, this), true);
    }

    public Money subtract() {
        return new Money(QuantLibJNI.Money_subtract__SWIG_0(this.swigCPtr, this), true);
    }

    public Money add(Money m) {
        return new Money(QuantLibJNI.Money_add__SWIG_1(this.swigCPtr, this, Money.getCPtr(m), m), true);
    }

    public Money subtract(Money m) {
        return new Money(QuantLibJNI.Money_subtract__SWIG_1(this.swigCPtr, this, Money.getCPtr(m), m), true);
    }

    public Money multiply(double x) {
        return new Money(QuantLibJNI.Money_multiply(this.swigCPtr, this, x), true);
    }

    public Money divide(double x) {
        return new Money(QuantLibJNI.Money_divide__SWIG_0(this.swigCPtr, this, x), true);
    }

    public double divide(Money m) {
        return QuantLibJNI.Money_divide__SWIG_1(this.swigCPtr, this, Money.getCPtr(m), m);
    }

    @Override
    public int compareTo(Money other) {
        return QuantLibJNI.Money_compareTo(this.swigCPtr, this, Money.getCPtr(other), other);
    }

    public boolean equals(Money other) {
        return QuantLibJNI.Money_equals(this.swigCPtr, this, Money.getCPtr(other), other);
    }

    public boolean unEquals(Money other) {
        return QuantLibJNI.Money_unEquals(this.swigCPtr, this, Money.getCPtr(other), other);
    }

    public String toString() {
        return QuantLibJNI.Money_toString(this.swigCPtr, this);
    }

    public static void setConversionType(ConversionType type) {
        QuantLibJNI.Money_setConversionType(type.swigValue());
    }

    public static void setBaseCurrency(Currency c) {
        QuantLibJNI.Money_setBaseCurrency(Currency.getCPtr(c), c);
    }

    public static final class ConversionType {
        public static final ConversionType NoConversion = new ConversionType("NoConversion");
        public static final ConversionType BaseCurrencyConversion = new ConversionType("BaseCurrencyConversion");
        public static final ConversionType AutomatedConversion = new ConversionType("AutomatedConversion");
        private static ConversionType[] swigValues = new ConversionType[]{NoConversion, BaseCurrencyConversion, AutomatedConversion};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static ConversionType swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && ConversionType.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (ConversionType.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(ConversionType.class) + " with value " + swigValue);
        }

        private ConversionType(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private ConversionType(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private ConversionType(String swigName, ConversionType swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

