/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.BusinessDayConvention;
import org.quantlib.Calendar;
import org.quantlib.Date;
import org.quantlib.DateGeneration;
import org.quantlib.DayCounter;
import org.quantlib.Frequency;
import org.quantlib.OvernightIndex;
import org.quantlib.OvernightIndexedSwap;
import org.quantlib.Period;
import org.quantlib.PricingEngine;
import org.quantlib.QuantLibJNI;
import org.quantlib.RateAveraging;
import org.quantlib.Swap;
import org.quantlib.YieldTermStructureHandle;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class MakeOIS
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MakeOIS(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(MakeOIS obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(MakeOIS obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_MakeOIS(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public MakeOIS(Period swapTenor, OvernightIndex overnightIndex, double fixedRate, Period fwdStart) {
        this(QuantLibJNI.new_MakeOIS__SWIG_0(Period.getCPtr(swapTenor), swapTenor, OvernightIndex.getCPtr(overnightIndex), overnightIndex, fixedRate, Period.getCPtr(fwdStart), fwdStart), true);
    }

    public MakeOIS(Period swapTenor, OvernightIndex overnightIndex, double fixedRate) {
        this(QuantLibJNI.new_MakeOIS__SWIG_1(Period.getCPtr(swapTenor), swapTenor, OvernightIndex.getCPtr(overnightIndex), overnightIndex, fixedRate), true);
    }

    public MakeOIS(Period swapTenor, OvernightIndex overnightIndex) {
        this(QuantLibJNI.new_MakeOIS__SWIG_2(Period.getCPtr(swapTenor), swapTenor, OvernightIndex.getCPtr(overnightIndex), overnightIndex), true);
    }

    public OvernightIndexedSwap makeOIS() {
        long cPtr = QuantLibJNI.MakeOIS_makeOIS(this.swigCPtr, this);
        return cPtr == 0L ? null : new OvernightIndexedSwap(cPtr, true);
    }

    public MakeOIS receiveFixed(boolean flag) {
        return new MakeOIS(QuantLibJNI.MakeOIS_receiveFixed__SWIG_0(this.swigCPtr, this, flag), false);
    }

    public MakeOIS receiveFixed() {
        return new MakeOIS(QuantLibJNI.MakeOIS_receiveFixed__SWIG_1(this.swigCPtr, this), false);
    }

    public MakeOIS withType(Swap.Type type) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withType(this.swigCPtr, this, type.swigValue()), false);
    }

    public MakeOIS withNominal(double n) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withNominal(this.swigCPtr, this, n), false);
    }

    public MakeOIS withSettlementDays(long settlementDays) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withSettlementDays(this.swigCPtr, this, settlementDays), false);
    }

    public MakeOIS withEffectiveDate(Date arg0) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withEffectiveDate(this.swigCPtr, this, Date.getCPtr(arg0), arg0), false);
    }

    public MakeOIS withTerminationDate(Date arg0) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withTerminationDate(this.swigCPtr, this, Date.getCPtr(arg0), arg0), false);
    }

    public MakeOIS withRule(DateGeneration.Rule r) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withRule(this.swigCPtr, this, r.swigValue()), false);
    }

    public MakeOIS withFixedLegRule(DateGeneration.Rule r) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withFixedLegRule(this.swigCPtr, this, r.swigValue()), false);
    }

    public MakeOIS withOvernightLegRule(DateGeneration.Rule r) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withOvernightLegRule(this.swigCPtr, this, r.swigValue()), false);
    }

    public MakeOIS withPaymentFrequency(Frequency f) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withPaymentFrequency(this.swigCPtr, this, f.swigValue()), false);
    }

    public MakeOIS withFixedLegPaymentFrequency(Frequency f) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withFixedLegPaymentFrequency(this.swigCPtr, this, f.swigValue()), false);
    }

    public MakeOIS withOvernightLegPaymentFrequency(Frequency f) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withOvernightLegPaymentFrequency(this.swigCPtr, this, f.swigValue()), false);
    }

    public MakeOIS withPaymentAdjustment(BusinessDayConvention convention) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withPaymentAdjustment(this.swigCPtr, this, convention.swigValue()), false);
    }

    public MakeOIS withPaymentLag(int lag) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withPaymentLag(this.swigCPtr, this, lag), false);
    }

    public MakeOIS withPaymentCalendar(Calendar cal) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withPaymentCalendar(this.swigCPtr, this, Calendar.getCPtr(cal), cal), false);
    }

    public MakeOIS withCalendar(Calendar cal) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withCalendar(this.swigCPtr, this, Calendar.getCPtr(cal), cal), false);
    }

    public MakeOIS withFixedLegCalendar(Calendar cal) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withFixedLegCalendar(this.swigCPtr, this, Calendar.getCPtr(cal), cal), false);
    }

    public MakeOIS withOvernightLegCalendar(Calendar cal) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withOvernightLegCalendar(this.swigCPtr, this, Calendar.getCPtr(cal), cal), false);
    }

    public MakeOIS withConvention(BusinessDayConvention bdc) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withConvention(this.swigCPtr, this, bdc.swigValue()), false);
    }

    public MakeOIS withFixedLegConvention(BusinessDayConvention bdc) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withFixedLegConvention(this.swigCPtr, this, bdc.swigValue()), false);
    }

    public MakeOIS withOvernightLegConvention(BusinessDayConvention bdc) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withOvernightLegConvention(this.swigCPtr, this, bdc.swigValue()), false);
    }

    public MakeOIS withTerminationDateConvention(BusinessDayConvention bdc) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withTerminationDateConvention(this.swigCPtr, this, bdc.swigValue()), false);
    }

    public MakeOIS withFixedLegTerminationDateConvention(BusinessDayConvention bdc) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withFixedLegTerminationDateConvention(this.swigCPtr, this, bdc.swigValue()), false);
    }

    public MakeOIS withOvernightLegTerminationDateConvention(BusinessDayConvention bdc) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withOvernightLegTerminationDateConvention(this.swigCPtr, this, bdc.swigValue()), false);
    }

    public MakeOIS withEndOfMonth(boolean flag) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withEndOfMonth__SWIG_0(this.swigCPtr, this, flag), false);
    }

    public MakeOIS withEndOfMonth() {
        return new MakeOIS(QuantLibJNI.MakeOIS_withEndOfMonth__SWIG_1(this.swigCPtr, this), false);
    }

    public MakeOIS withFixedLegEndOfMonth(boolean flag) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withFixedLegEndOfMonth__SWIG_0(this.swigCPtr, this, flag), false);
    }

    public MakeOIS withFixedLegEndOfMonth() {
        return new MakeOIS(QuantLibJNI.MakeOIS_withFixedLegEndOfMonth__SWIG_1(this.swigCPtr, this), false);
    }

    public MakeOIS withOvernightLegEndOfMonth(boolean flag) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withOvernightLegEndOfMonth__SWIG_0(this.swigCPtr, this, flag), false);
    }

    public MakeOIS withOvernightLegEndOfMonth() {
        return new MakeOIS(QuantLibJNI.MakeOIS_withOvernightLegEndOfMonth__SWIG_1(this.swigCPtr, this), false);
    }

    public MakeOIS withFixedLegDayCount(DayCounter dc) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withFixedLegDayCount(this.swigCPtr, this, DayCounter.getCPtr(dc), dc), false);
    }

    public MakeOIS withOvernightLegSpread(double sp) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withOvernightLegSpread(this.swigCPtr, this, sp), false);
    }

    public MakeOIS withDiscountingTermStructure(YieldTermStructureHandle discountingTermStructure) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withDiscountingTermStructure(this.swigCPtr, this, YieldTermStructureHandle.getCPtr(discountingTermStructure), discountingTermStructure), false);
    }

    public MakeOIS withTelescopicValueDates(boolean telescopicValueDates) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withTelescopicValueDates(this.swigCPtr, this, telescopicValueDates), false);
    }

    public MakeOIS withAveragingMethod(RateAveraging.Type averagingMethod) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withAveragingMethod(this.swigCPtr, this, averagingMethod.swigValue()), false);
    }

    public MakeOIS withLookbackDays(long lookbackDays) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withLookbackDays(this.swigCPtr, this, lookbackDays), false);
    }

    public MakeOIS withLockoutDays(long lockoutDays) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withLockoutDays(this.swigCPtr, this, lockoutDays), false);
    }

    public MakeOIS withObservationShift(boolean applyObservationShift) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withObservationShift__SWIG_0(this.swigCPtr, this, applyObservationShift), false);
    }

    public MakeOIS withObservationShift() {
        return new MakeOIS(QuantLibJNI.MakeOIS_withObservationShift__SWIG_1(this.swigCPtr, this), false);
    }

    public MakeOIS withPricingEngine(PricingEngine engine) {
        return new MakeOIS(QuantLibJNI.MakeOIS_withPricingEngine(this.swigCPtr, this, PricingEngine.getCPtr(engine), engine), false);
    }
}

