/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.BusinessDayConvention;
import org.quantlib.Calendar;
import org.quantlib.Compounding;
import org.quantlib.Date;
import org.quantlib.DayCounter;
import org.quantlib.Instrument;
import org.quantlib.InterestRate;
import org.quantlib.QuantLibJNI;
import org.quantlib.YieldTermStructureHandle;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class Forward
extends Instrument
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected Forward(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.Forward_SWIGSmartPtrUpcast(cPtr), true);
        this.swigCMemOwnDerived = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Forward obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean own) {
        this.swigCMemOwnDerived = own;
        super.swigSetCMemOwn(own);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                QuantLibJNI.delete_Forward(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Date settlementDate() {
        return new Date(QuantLibJNI.Forward_settlementDate(this.swigCPtr, this), true);
    }

    @Override
    public boolean isExpired() {
        return QuantLibJNI.Forward_isExpired(this.swigCPtr, this);
    }

    public Calendar calendar() {
        return new Calendar(QuantLibJNI.Forward_calendar(this.swigCPtr, this), false);
    }

    public BusinessDayConvention businessDayConvention() {
        return BusinessDayConvention.swigToEnum(QuantLibJNI.Forward_businessDayConvention(this.swigCPtr, this));
    }

    public DayCounter dayCounter() {
        return new DayCounter(QuantLibJNI.Forward_dayCounter(this.swigCPtr, this), false);
    }

    public YieldTermStructureHandle discountCurve() {
        return new YieldTermStructureHandle(QuantLibJNI.Forward_discountCurve(this.swigCPtr, this), true);
    }

    public YieldTermStructureHandle incomeDiscountCurve() {
        return new YieldTermStructureHandle(QuantLibJNI.Forward_incomeDiscountCurve(this.swigCPtr, this), true);
    }

    public double spotValue() {
        return QuantLibJNI.Forward_spotValue(this.swigCPtr, this);
    }

    public double spotIncome(YieldTermStructureHandle incomeDiscountCurve) {
        return QuantLibJNI.Forward_spotIncome(this.swigCPtr, this, YieldTermStructureHandle.getCPtr(incomeDiscountCurve), incomeDiscountCurve);
    }

    public double forwardValue() {
        return QuantLibJNI.Forward_forwardValue(this.swigCPtr, this);
    }

    public InterestRate impliedYield(double underlyingSpotValue, double forwardValue, Date settlementDate, Compounding compoundingConvention, DayCounter dayCounter) {
        return new InterestRate(QuantLibJNI.Forward_impliedYield(this.swigCPtr, this, underlyingSpotValue, forwardValue, Date.getCPtr(settlementDate), settlementDate, compoundingConvention.swigValue(), DayCounter.getCPtr(dayCounter), dayCounter), true);
    }
}

