/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.quantlib.QuantLibJNI;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class DoubleVector
extends AbstractList<Double>
implements QuantLibJNIHelpers.AutoCloseable,
RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected DoubleVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DoubleVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(DoubleVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_DoubleVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public DoubleVector(double[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (double element : initialElements) {
            this.add(element);
        }
    }

    public DoubleVector(Iterable<Double> initialElements) {
        this();
        for (double element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Double get(int index) {
        return this.doGet(index);
    }

    @Override
    public Double set(int index, Double e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Double e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Double e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Double remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public DoubleVector() {
        this(QuantLibJNI.new_DoubleVector__SWIG_0(), true);
    }

    public DoubleVector(DoubleVector other) {
        this(QuantLibJNI.new_DoubleVector__SWIG_1(DoubleVector.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return QuantLibJNI.DoubleVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        QuantLibJNI.DoubleVector_clear(this.swigCPtr, this);
    }

    public DoubleVector(int count, double value) {
        this(QuantLibJNI.new_DoubleVector__SWIG_2(count, value), true);
    }

    private int doCapacity() {
        return QuantLibJNI.DoubleVector_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        QuantLibJNI.DoubleVector_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return QuantLibJNI.DoubleVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(double x) {
        QuantLibJNI.DoubleVector_doAdd__SWIG_0(this.swigCPtr, this, x);
    }

    private void doAdd(int index, double x) {
        QuantLibJNI.DoubleVector_doAdd__SWIG_1(this.swigCPtr, this, index, x);
    }

    private double doRemove(int index) {
        return QuantLibJNI.DoubleVector_doRemove(this.swigCPtr, this, index);
    }

    private double doGet(int index) {
        return QuantLibJNI.DoubleVector_doGet(this.swigCPtr, this, index);
    }

    private double doSet(int index, double val) {
        return QuantLibJNI.DoubleVector_doSet(this.swigCPtr, this, index, val);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        QuantLibJNI.DoubleVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

