/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.quantlib.Dividend;
import org.quantlib.QuantLibJNI;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class DividendSchedule
extends AbstractList<Dividend>
implements QuantLibJNIHelpers.AutoCloseable,
RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected DividendSchedule(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(DividendSchedule obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(DividendSchedule obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_DividendSchedule(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public DividendSchedule(Dividend[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (Dividend element : initialElements) {
            this.add(element);
        }
    }

    public DividendSchedule(Iterable<Dividend> initialElements) {
        this();
        for (Dividend element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Dividend get(int index) {
        return this.doGet(index);
    }

    @Override
    public Dividend set(int index, Dividend e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Dividend e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Dividend e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Dividend remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public DividendSchedule() {
        this(QuantLibJNI.new_DividendSchedule__SWIG_0(), true);
    }

    public DividendSchedule(DividendSchedule other) {
        this(QuantLibJNI.new_DividendSchedule__SWIG_1(DividendSchedule.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return QuantLibJNI.DividendSchedule_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        QuantLibJNI.DividendSchedule_clear(this.swigCPtr, this);
    }

    public DividendSchedule(int count, Dividend value) {
        this(QuantLibJNI.new_DividendSchedule__SWIG_2(count, Dividend.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return QuantLibJNI.DividendSchedule_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        QuantLibJNI.DividendSchedule_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return QuantLibJNI.DividendSchedule_doSize(this.swigCPtr, this);
    }

    private void doAdd(Dividend x) {
        QuantLibJNI.DividendSchedule_doAdd__SWIG_0(this.swigCPtr, this, Dividend.getCPtr(x), x);
    }

    private void doAdd(int index, Dividend x) {
        QuantLibJNI.DividendSchedule_doAdd__SWIG_1(this.swigCPtr, this, index, Dividend.getCPtr(x), x);
    }

    private Dividend doRemove(int index) {
        long cPtr = QuantLibJNI.DividendSchedule_doRemove(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new Dividend(cPtr, true);
    }

    private Dividend doGet(int index) {
        long cPtr = QuantLibJNI.DividendSchedule_doGet(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new Dividend(cPtr, true);
    }

    private Dividend doSet(int index, Dividend val) {
        long cPtr = QuantLibJNI.DividendSchedule_doSet(this.swigCPtr, this, index, Dividend.getCPtr(val), val);
        return cPtr == 0L ? null : new Dividend(cPtr, true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        QuantLibJNI.DividendSchedule_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

