/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import java.time.LocalDate;
import org.quantlib.Month;
import org.quantlib.Period;
import org.quantlib.QuantLibJNI;
import org.quantlib.Weekday;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class Date
implements QuantLibJNIHelpers.AutoCloseable,
Comparable<Date> {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Date(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Date obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Date obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_Date(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public Date() {
        this(QuantLibJNI.new_Date__SWIG_0(), true);
    }

    public Date(int d, Month m, int y) {
        this(QuantLibJNI.new_Date__SWIG_1(d, m.swigValue(), y), true);
    }

    public Date(int d, Month m, int y, int hours, int minutes, int seconds, int millisec, int microsec) {
        this(QuantLibJNI.new_Date__SWIG_2(d, m.swigValue(), y, hours, minutes, seconds, millisec, microsec), true);
    }

    public Date(int d, Month m, int y, int hours, int minutes, int seconds, int millisec) {
        this(QuantLibJNI.new_Date__SWIG_3(d, m.swigValue(), y, hours, minutes, seconds, millisec), true);
    }

    public Date(int d, Month m, int y, int hours, int minutes, int seconds) {
        this(QuantLibJNI.new_Date__SWIG_4(d, m.swigValue(), y, hours, minutes, seconds), true);
    }

    public Date(int serialNumber) {
        this(QuantLibJNI.new_Date__SWIG_5(serialNumber), true);
    }

    public Weekday weekday() {
        return Weekday.swigToEnum(QuantLibJNI.Date_weekday(this.swigCPtr, this));
    }

    public int dayOfMonth() {
        return QuantLibJNI.Date_dayOfMonth(this.swigCPtr, this);
    }

    public int dayOfYear() {
        return QuantLibJNI.Date_dayOfYear(this.swigCPtr, this);
    }

    public Month month() {
        return Month.swigToEnum(QuantLibJNI.Date_month(this.swigCPtr, this));
    }

    public int year() {
        return QuantLibJNI.Date_year(this.swigCPtr, this);
    }

    public int hours() {
        return QuantLibJNI.Date_hours(this.swigCPtr, this);
    }

    public int minutes() {
        return QuantLibJNI.Date_minutes(this.swigCPtr, this);
    }

    public int seconds() {
        return QuantLibJNI.Date_seconds(this.swigCPtr, this);
    }

    public int milliseconds() {
        return QuantLibJNI.Date_milliseconds(this.swigCPtr, this);
    }

    public int microseconds() {
        return QuantLibJNI.Date_microseconds(this.swigCPtr, this);
    }

    public double fractionOfDay() {
        return QuantLibJNI.Date_fractionOfDay(this.swigCPtr, this);
    }

    public double fractionOfSecond() {
        return QuantLibJNI.Date_fractionOfSecond(this.swigCPtr, this);
    }

    public int serialNumber() {
        return QuantLibJNI.Date_serialNumber(this.swigCPtr, this);
    }

    public static boolean isLeap(int y) {
        return QuantLibJNI.Date_isLeap(y);
    }

    public static Date minDate() {
        return new Date(QuantLibJNI.Date_minDate(), true);
    }

    public static Date maxDate() {
        return new Date(QuantLibJNI.Date_maxDate(), true);
    }

    public static Date todaysDate() {
        return new Date(QuantLibJNI.Date_todaysDate(), true);
    }

    public static Date localDateTime() {
        return new Date(QuantLibJNI.Date_localDateTime(), true);
    }

    public static Date universalDateTime() {
        return new Date(QuantLibJNI.Date_universalDateTime(), true);
    }

    public static Date startOfMonth(Date arg0) {
        return new Date(QuantLibJNI.Date_startOfMonth(Date.getCPtr(arg0), arg0), true);
    }

    public static Date endOfMonth(Date arg0) {
        return new Date(QuantLibJNI.Date_endOfMonth(Date.getCPtr(arg0), arg0), true);
    }

    public static boolean isStartOfMonth(Date arg0) {
        return QuantLibJNI.Date_isStartOfMonth(Date.getCPtr(arg0), arg0);
    }

    public static boolean isEndOfMonth(Date arg0) {
        return QuantLibJNI.Date_isEndOfMonth(Date.getCPtr(arg0), arg0);
    }

    public static Date nextWeekday(Date arg0, Weekday arg1) {
        return new Date(QuantLibJNI.Date_nextWeekday(Date.getCPtr(arg0), arg0, arg1.swigValue()), true);
    }

    public static Date nthWeekday(long n, Weekday arg1, Month m, int y) {
        return new Date(QuantLibJNI.Date_nthWeekday(n, arg1.swigValue(), m.swigValue(), y), true);
    }

    public Date add(int days) {
        return new Date(QuantLibJNI.Date_add__SWIG_0(this.swigCPtr, this, days), true);
    }

    public Date subtract(int days) {
        return new Date(QuantLibJNI.Date_subtract__SWIG_0(this.swigCPtr, this, days), true);
    }

    public Date add(Period arg0) {
        return new Date(QuantLibJNI.Date_add__SWIG_1(this.swigCPtr, this, Period.getCPtr(arg0), arg0), true);
    }

    public Date subtract(Period arg0) {
        return new Date(QuantLibJNI.Date_subtract__SWIG_1(this.swigCPtr, this, Period.getCPtr(arg0), arg0), true);
    }

    public Date(String str, String fmt) {
        this(QuantLibJNI.new_Date__SWIG_6(str, fmt), true);
    }

    public int weekdayNumber() {
        return QuantLibJNI.Date_weekdayNumber(this.swigCPtr, this);
    }

    public String toString() {
        return QuantLibJNI.Date_toString(this.swigCPtr, this);
    }

    public String repr() {
        return QuantLibJNI.Date_repr(this.swigCPtr, this);
    }

    public String ISO() {
        return QuantLibJNI.Date_ISO(this.swigCPtr, this);
    }

    public int subtract(Date other) {
        return QuantLibJNI.Date_subtract__SWIG_2(this.swigCPtr, this, Date.getCPtr(other), other);
    }

    public boolean equals(Date other) {
        return QuantLibJNI.Date_equals(this.swigCPtr, this, Date.getCPtr(other), other);
    }

    public boolean unEquals(Date other) {
        return QuantLibJNI.Date_unEquals(this.swigCPtr, this, Date.getCPtr(other), other);
    }

    public int hashCode() {
        return QuantLibJNI.Date_hashCode(this.swigCPtr, this);
    }

    @Override
    public int compareTo(Date other) {
        return QuantLibJNI.Date_compareTo(this.swigCPtr, this, Date.getCPtr(other), other);
    }

    public static Date of(LocalDate localDate) {
        return new Date(localDate.getDayOfMonth(), Month.swigToEnum(localDate.getMonthValue()), localDate.getYear());
    }

    public LocalDate toLocalDate() {
        return LocalDate.of(this.year(), this.month().swigValue(), this.dayOfMonth());
    }
}

