/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.QuantLibJNI;
import org.quantlib.Rounding;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class Currency
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Currency(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Currency obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Currency obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_Currency(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public Currency() {
        this(QuantLibJNI.new_Currency__SWIG_0(), true);
    }

    public Currency(String name, String code, int numericCode, String symbol, String fractionSymbol, int fractionsPerUnit, Rounding rounding, Currency triangulationCurrency) {
        this(QuantLibJNI.new_Currency__SWIG_1(name, code, numericCode, symbol, fractionSymbol, fractionsPerUnit, Rounding.getCPtr(rounding), rounding, Currency.getCPtr(triangulationCurrency), triangulationCurrency), true);
    }

    public Currency(String name, String code, int numericCode, String symbol, String fractionSymbol, int fractionsPerUnit, Rounding rounding) {
        this(QuantLibJNI.new_Currency__SWIG_2(name, code, numericCode, symbol, fractionSymbol, fractionsPerUnit, Rounding.getCPtr(rounding), rounding), true);
    }

    public String name() {
        return QuantLibJNI.Currency_name(this.swigCPtr, this);
    }

    public String code() {
        return QuantLibJNI.Currency_code(this.swigCPtr, this);
    }

    public int numericCode() {
        return QuantLibJNI.Currency_numericCode(this.swigCPtr, this);
    }

    public String symbol() {
        return QuantLibJNI.Currency_symbol(this.swigCPtr, this);
    }

    public String fractionSymbol() {
        return QuantLibJNI.Currency_fractionSymbol(this.swigCPtr, this);
    }

    public int fractionsPerUnit() {
        return QuantLibJNI.Currency_fractionsPerUnit(this.swigCPtr, this);
    }

    public Rounding rounding() {
        return new Rounding(QuantLibJNI.Currency_rounding(this.swigCPtr, this), false);
    }

    public boolean empty() {
        return QuantLibJNI.Currency_empty(this.swigCPtr, this);
    }

    public Currency triangulationCurrency() {
        return new Currency(QuantLibJNI.Currency_triangulationCurrency(this.swigCPtr, this), false);
    }

    public String toString() {
        return QuantLibJNI.Currency_toString(this.swigCPtr, this);
    }

    public boolean equals(Currency other) {
        return QuantLibJNI.Currency_equals(this.swigCPtr, this, Currency.getCPtr(other), other);
    }

    public boolean unEquals(Currency other) {
        return QuantLibJNI.Currency_unEquals(this.swigCPtr, this, Currency.getCPtr(other), other);
    }

    public int hashCode() {
        return QuantLibJNI.Currency_hashCode(this.swigCPtr, this);
    }
}

