/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.Array;
import org.quantlib.CmsCouponPricerVector;
import org.quantlib.IborIndex;
import org.quantlib.Matrix;
import org.quantlib.PeriodVector;
import org.quantlib.QuantLibJNI;
import org.quantlib.QuoteHandleVectorVector;
import org.quantlib.SwapIndexVector;
import org.quantlib.SwaptionVolatilityStructureHandle;
import org.quantlib.YieldTermStructureHandle;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class CmsMarket
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    private transient boolean swigCMemOwn;

    protected CmsMarket(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(CmsMarket obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void swigSetCMemOwn(boolean own) {
        this.swigCMemOwn = own;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_CmsMarket(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public CmsMarket(PeriodVector swapLengths, SwapIndexVector swapIndexes, IborIndex iborIndex, QuoteHandleVectorVector bidAskSpreads, CmsCouponPricerVector pricers, YieldTermStructureHandle discountingTS) {
        this(QuantLibJNI.new_CmsMarket(PeriodVector.getCPtr(swapLengths), swapLengths, SwapIndexVector.getCPtr(swapIndexes), swapIndexes, IborIndex.getCPtr(iborIndex), iborIndex, QuoteHandleVectorVector.getCPtr(bidAskSpreads), bidAskSpreads, CmsCouponPricerVector.getCPtr(pricers), pricers, YieldTermStructureHandle.getCPtr(discountingTS), discountingTS), true);
    }

    public void reprice(SwaptionVolatilityStructureHandle volStructure, double meanReversion) {
        QuantLibJNI.CmsMarket_reprice(this.swigCPtr, this, SwaptionVolatilityStructureHandle.getCPtr(volStructure), volStructure, meanReversion);
    }

    public PeriodVector swapTenors() {
        return new PeriodVector(QuantLibJNI.CmsMarket_swapTenors(this.swigCPtr, this), false);
    }

    public PeriodVector swapLengths() {
        return new PeriodVector(QuantLibJNI.CmsMarket_swapLengths(this.swigCPtr, this), false);
    }

    public Matrix impliedCmsSpreads() {
        return new Matrix(QuantLibJNI.CmsMarket_impliedCmsSpreads(this.swigCPtr, this), false);
    }

    public Matrix spreadErrors() {
        return new Matrix(QuantLibJNI.CmsMarket_spreadErrors(this.swigCPtr, this), false);
    }

    public Matrix browse() {
        return new Matrix(QuantLibJNI.CmsMarket_browse(this.swigCPtr, this), true);
    }

    public double weightedSpreadError(Matrix weights) {
        return QuantLibJNI.CmsMarket_weightedSpreadError(this.swigCPtr, this, Matrix.getCPtr(weights), weights);
    }

    public double weightedSpotNpvError(Matrix weights) {
        return QuantLibJNI.CmsMarket_weightedSpotNpvError(this.swigCPtr, this, Matrix.getCPtr(weights), weights);
    }

    public double weightedFwdNpvError(Matrix weights) {
        return QuantLibJNI.CmsMarket_weightedFwdNpvError(this.swigCPtr, this, Matrix.getCPtr(weights), weights);
    }

    public Array weightedSpreadErrors(Matrix weights) {
        return new Array(QuantLibJNI.CmsMarket_weightedSpreadErrors(this.swigCPtr, this, Matrix.getCPtr(weights), weights), true);
    }

    public Array weightedSpotNpvErrors(Matrix weights) {
        return new Array(QuantLibJNI.CmsMarket_weightedSpotNpvErrors(this.swigCPtr, this, Matrix.getCPtr(weights), weights), true);
    }

    public Array weightedFwdNpvErrors(Matrix weights) {
        return new Array(QuantLibJNI.CmsMarket_weightedFwdNpvErrors(this.swigCPtr, this, Matrix.getCPtr(weights), weights), true);
    }
}

