/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.Date;
import org.quantlib.DoubleVector;
import org.quantlib.Instrument;
import org.quantlib.Leg;
import org.quantlib.QuantLibJNI;
import org.quantlib.VolatilityType;
import org.quantlib.YieldTermStructure;
import org.quantlib.YieldTermStructureHandle;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class CapFloor
extends Instrument
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected CapFloor(long cPtr, boolean cMemoryOwn) {
        super(QuantLibJNI.CapFloor_SWIGSmartPtrUpcast(cPtr), true);
        this.swigCMemOwnDerived = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(CapFloor obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean own) {
        this.swigCMemOwnDerived = own;
        super.swigSetCMemOwn(own);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                QuantLibJNI.delete_CapFloor(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public double impliedVolatility(double price, YieldTermStructureHandle disc, double guess, double accuracy, long maxEvaluations, double minVol, double maxVol, VolatilityType type, double displacement) {
        return QuantLibJNI.CapFloor_impliedVolatility__SWIG_0(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(disc), disc, guess, accuracy, maxEvaluations, minVol, maxVol, type.swigValue(), displacement);
    }

    public double impliedVolatility(double price, YieldTermStructureHandle disc, double guess, double accuracy, long maxEvaluations, double minVol, double maxVol, VolatilityType type) {
        return QuantLibJNI.CapFloor_impliedVolatility__SWIG_1(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(disc), disc, guess, accuracy, maxEvaluations, minVol, maxVol, type.swigValue());
    }

    public double impliedVolatility(double price, YieldTermStructureHandle disc, double guess, double accuracy, long maxEvaluations, double minVol, double maxVol) {
        return QuantLibJNI.CapFloor_impliedVolatility__SWIG_2(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(disc), disc, guess, accuracy, maxEvaluations, minVol, maxVol);
    }

    public double impliedVolatility(double price, YieldTermStructureHandle disc, double guess, double accuracy, long maxEvaluations, double minVol) {
        return QuantLibJNI.CapFloor_impliedVolatility__SWIG_3(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(disc), disc, guess, accuracy, maxEvaluations, minVol);
    }

    public double impliedVolatility(double price, YieldTermStructureHandle disc, double guess, double accuracy, long maxEvaluations) {
        return QuantLibJNI.CapFloor_impliedVolatility__SWIG_4(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(disc), disc, guess, accuracy, maxEvaluations);
    }

    public double impliedVolatility(double price, YieldTermStructureHandle disc, double guess, double accuracy) {
        return QuantLibJNI.CapFloor_impliedVolatility__SWIG_5(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(disc), disc, guess, accuracy);
    }

    public double impliedVolatility(double price, YieldTermStructureHandle disc, double guess) {
        return QuantLibJNI.CapFloor_impliedVolatility__SWIG_6(this.swigCPtr, this, price, YieldTermStructureHandle.getCPtr(disc), disc, guess);
    }

    public Leg floatingLeg() {
        return new Leg(QuantLibJNI.CapFloor_floatingLeg(this.swigCPtr, this), false);
    }

    public DoubleVector capRates() {
        return new DoubleVector(QuantLibJNI.CapFloor_capRates(this.swigCPtr, this), false);
    }

    public DoubleVector floorRates() {
        return new DoubleVector(QuantLibJNI.CapFloor_floorRates(this.swigCPtr, this), false);
    }

    public Date startDate() {
        return new Date(QuantLibJNI.CapFloor_startDate(this.swigCPtr, this), true);
    }

    public Date maturityDate() {
        return new Date(QuantLibJNI.CapFloor_maturityDate(this.swigCPtr, this), true);
    }

    public Type type() {
        return Type.swigToEnum(QuantLibJNI.CapFloor_type(this.swigCPtr, this));
    }

    public double atmRate(YieldTermStructure discountCurve) {
        return QuantLibJNI.CapFloor_atmRate(this.swigCPtr, this, YieldTermStructure.getCPtr(discountCurve), discountCurve);
    }

    public double vega() {
        return QuantLibJNI.CapFloor_vega(this.swigCPtr, this);
    }

    public DoubleVector optionletsPrice() {
        return new DoubleVector(QuantLibJNI.CapFloor_optionletsPrice(this.swigCPtr, this), true);
    }

    public DoubleVector optionletsVega() {
        return new DoubleVector(QuantLibJNI.CapFloor_optionletsVega(this.swigCPtr, this), true);
    }

    public DoubleVector optionletsDelta() {
        return new DoubleVector(QuantLibJNI.CapFloor_optionletsDelta(this.swigCPtr, this), true);
    }

    public DoubleVector optionletsDiscountFactor() {
        return new DoubleVector(QuantLibJNI.CapFloor_optionletsDiscountFactor(this.swigCPtr, this), true);
    }

    public DoubleVector optionletsAtmForward() {
        return new DoubleVector(QuantLibJNI.CapFloor_optionletsAtmForward(this.swigCPtr, this), true);
    }

    public DoubleVector optionletsStdDev() {
        return new DoubleVector(QuantLibJNI.CapFloor_optionletsStdDev(this.swigCPtr, this), true);
    }

    public static final class Type {
        public static final Type Cap = new Type("Cap");
        public static final Type Floor = new Type("Floor");
        public static final Type Collar = new Type("Collar");
        private static Type[] swigValues = new Type[]{Cap, Floor, Collar};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static Type swigToEnum(int swigValue) {
            if (swigValue < swigValues.length && swigValue >= 0 && Type.swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (Type.swigValues[i].swigValue != swigValue) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(Type.class) + " with value " + swigValue);
        }

        private Type(String swigName) {
            this.swigName = swigName;
            this.swigValue = swigNext++;
        }

        private Type(String swigName, int swigValue) {
            this.swigName = swigName;
            this.swigValue = swigValue;
            swigNext = swigValue + 1;
        }

        private Type(String swigName, Type swigEnum) {
            this.swigName = swigName;
            this.swigValue = swigEnum.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

