/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.quantlib.Calendar;
import org.quantlib.QuantLibJNI;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class CalendarVector
extends AbstractList<Calendar>
implements QuantLibJNIHelpers.AutoCloseable,
RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected CalendarVector(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(CalendarVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(CalendarVector obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_CalendarVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public CalendarVector(Calendar[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (Calendar element : initialElements) {
            this.add(element);
        }
    }

    public CalendarVector(Iterable<Calendar> initialElements) {
        this();
        for (Calendar element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Calendar get(int index) {
        return this.doGet(index);
    }

    @Override
    public Calendar set(int index, Calendar e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Calendar e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Calendar e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Calendar remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public CalendarVector() {
        this(QuantLibJNI.new_CalendarVector__SWIG_0(), true);
    }

    public CalendarVector(CalendarVector other) {
        this(QuantLibJNI.new_CalendarVector__SWIG_1(CalendarVector.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return QuantLibJNI.CalendarVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        QuantLibJNI.CalendarVector_clear(this.swigCPtr, this);
    }

    public CalendarVector(int count, Calendar value) {
        this(QuantLibJNI.new_CalendarVector__SWIG_2(count, Calendar.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return QuantLibJNI.CalendarVector_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        QuantLibJNI.CalendarVector_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return QuantLibJNI.CalendarVector_doSize(this.swigCPtr, this);
    }

    private void doAdd(Calendar x) {
        QuantLibJNI.CalendarVector_doAdd__SWIG_0(this.swigCPtr, this, Calendar.getCPtr(x), x);
    }

    private void doAdd(int index, Calendar x) {
        QuantLibJNI.CalendarVector_doAdd__SWIG_1(this.swigCPtr, this, index, Calendar.getCPtr(x), x);
    }

    private Calendar doRemove(int index) {
        return new Calendar(QuantLibJNI.CalendarVector_doRemove(this.swigCPtr, this, index), true);
    }

    private Calendar doGet(int index) {
        return new Calendar(QuantLibJNI.CalendarVector_doGet(this.swigCPtr, this, index), false);
    }

    private Calendar doSet(int index, Calendar val) {
        return new Calendar(QuantLibJNI.CalendarVector_doSet(this.swigCPtr, this, index, Calendar.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        QuantLibJNI.CalendarVector_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

