/*
 * Decompiled with CFR 0.152.
 */
package org.quantlib;

import org.quantlib.DoubleVector;
import org.quantlib.QuantLibJNI;
import org.quantlib.TimeGrid;
import org.quantlib.UnsignedIntVector;
import org.quantlib.helpers.QuantLibJNIHelpers;

public class BrownianBridge
implements QuantLibJNIHelpers.AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected BrownianBridge(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(BrownianBridge obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(BrownianBridge obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                QuantLibJNI.delete_BrownianBridge(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public BrownianBridge(long steps) {
        this(QuantLibJNI.new_BrownianBridge__SWIG_0(steps), true);
    }

    public BrownianBridge(DoubleVector times) {
        this(QuantLibJNI.new_BrownianBridge__SWIG_1(DoubleVector.getCPtr(times), times), true);
    }

    public BrownianBridge(TimeGrid timeGrid) {
        this(QuantLibJNI.new_BrownianBridge__SWIG_2(TimeGrid.getCPtr(timeGrid), timeGrid), true);
    }

    public long size() {
        return QuantLibJNI.BrownianBridge_size(this.swigCPtr, this);
    }

    public DoubleVector times() {
        return new DoubleVector(QuantLibJNI.BrownianBridge_times(this.swigCPtr, this), true);
    }

    public DoubleVector leftWeight() {
        return new DoubleVector(QuantLibJNI.BrownianBridge_leftWeight(this.swigCPtr, this), true);
    }

    public DoubleVector rightWeight() {
        return new DoubleVector(QuantLibJNI.BrownianBridge_rightWeight(this.swigCPtr, this), true);
    }

    public DoubleVector stdDeviation() {
        return new DoubleVector(QuantLibJNI.BrownianBridge_stdDeviation(this.swigCPtr, this), true);
    }

    public DoubleVector transform(DoubleVector input) {
        return new DoubleVector(QuantLibJNI.BrownianBridge_transform(this.swigCPtr, this, DoubleVector.getCPtr(input), input), true);
    }

    public UnsignedIntVector bridgeIndex() {
        return new UnsignedIntVector(QuantLibJNI.BrownianBridge_bridgeIndex(this.swigCPtr, this), true);
    }

    public UnsignedIntVector leftIndex() {
        return new UnsignedIntVector(QuantLibJNI.BrownianBridge_leftIndex(this.swigCPtr, this), true);
    }

    public UnsignedIntVector rightIndex() {
        return new UnsignedIntVector(QuantLibJNI.BrownianBridge_rightIndex(this.swigCPtr, this), true);
    }
}

